// Calcul de la racine carre avec une lambda expression
//
// Cela ne fonctionne que avec au moins la version 8.0 de Java
//
import java.util.function.*;
import java.util.*;


// ===  Interface d'une formule recurent
//
interface Formule
{
    // Caclule la valeur suivante de d
    public double suiv(double d);

    public default int toto(int x){return 0;}; // Pour faire un test
    
}

// Classe contenant une methode generique qui
//  realise le calcul d'une fonction recurrente
//
class Serie
{
    public double calculer(double u_0,Formule f)
    {
        double u_n = u_0;
        double u_n1 = f.suiv(u_n);
        while(Math.abs(u_n - u_n1)>0.0000001)
            {
                u_n=u_n1;
                u_n1 = f.suiv(u_n);
            }
        return u_n;
    }
}


// Inutile si on utilise les lambdas expression
// On utilise cette classe pour comparer entre une implementation
//  sans utiliser une class anonyme ou une lambda expression
//
// Classe de calcul de la racine carre d'un nombre
//
class RacineCarree implements Formule
{
    private double valeur;

    public RacineCarree(double valeur)
    {
        this.valeur = valeur;
    }

    public double suiv(double x)
    {
        return 0.5*(x+valeur/x);
    }

}

// ============== PROGRAMME PRINCIPAL
//
public class Exemple37
{
    public static void main(String[] args) 
    { 
        // 
        Serie serie = new Serie();
        
        // ----  Classiquement
        double valeur = 3.0; 
        RacineCarree rc = new RacineCarree(valeur);
        double resultat = serie.calculer(1.0,rc);
        System.out.println("racine carre de "+valeur+" = "+resultat);

        // ---- Avec une classe hanonyme
        System.out.println(serie.calculer(1.0,
                                          new Formule(){
                                              public double suiv(double x){
                                                  return 0.5*(x+valeur/x);}
                                          }));

        // Si l'interface Formule contient une deuxième méthode alors on a 
        //   l'erreur de compilation suivante :
        // error: <anonymous Exemple36$1> is not abstract and does not 
        //    override abstract method toto(int) in Formule
        //
        // par contre si la deuxième méthode (ici toto) est marquée
        //   default on n'a plus d'erreur de compilation
        

        // ---- Avec une lambda expression
        System.out.println(new Serie().calculer(1.0,(x)->0.5*(x+3.0/x)));

    }
}

