// Exemple de l'utilisation des streams
// Cela ne fonctionne que avec au moins la version 8.0 de Java
//
import java.util.function.*;
import java.util.*;
import java.util.stream.*;

// La classe de definition d'une personne
//
class Personne
{ 
    private String nom;
    private String prenom;
    private  int age;

    public Personne(String nom,String prenom,int age)
    {
        this.nom=nom;
        this.prenom=prenom;
        this.age=age;
    }
    
    public int getAge(){return age;}
    public String getNom(){return nom;}
    public String getPrenom(){return prenom;}
    public String toString(){return String.format("%15s %15s %3d",nom,prenom,age);}
}


// ============== PROGRAMME PRINCIPAL
//
public class Exemple38
{
	public static void main(String[] args) 
    {
        // Initialisation de la liste de personnes
        //
        Personne p1 = new Personne("LAFONT","Paul",35);
        Personne p2 = new Personne("DUPONT","Andre",50);
        Personne p3 = new Personne("ZOERIA","Sylvie",25);
        Personne p4 = new Personne("DUPONT","Paul",20);

        ArrayList<Personne> l = new ArrayList<Personne>();
        l.add(p1);
        l.add(p2);
        l.add(p3);
        l.add(p4);

        System.out.println("------------------------------------");
        System.out.println("--- Utilisation de la methode forEach");
        System.out.println("--- Affichage des ages des personnes");
        Consumer<Personne> action = (Personne p) -> System.out.println(p.getAge());
        l.stream().forEach(action);

        System.out.println("------------------------------------");
        System.out.println("--- Utilisation de la methode map");
        System.out.println("--- Affichage des noms des personnes ");
        l.stream().map((p)->"//"+p.getNom()+"//").forEach((o)->System.out.println(o));


        System.out.println("------------------------------------");
        System.out.println("--- Utilisation de la methode map filter reduce");
        //Affiche toutes les personnes
        l.stream().forEach((p)->System.out.println(p));
        System.out.println("--- Calcule la somme des ages des personnes qui ont plus de 30 ans");
        int sum = l.stream()
            .map((p)->p.getAge())
            .filter( (n)->n>30 )
            .reduce(0,(x,y)->x+y);
        System.out.println("sum="+sum);
        
        System.out.println("------------------------------------");
        String rechNom="DUPONT";
        System.out.println("Recherche des personnes sur le nom "+rechNom);
        l.stream().filter((p)->p.getNom().equals(rechNom)).forEach((o)->System.out.println(o));
        System.out.println("----");
        String rechPrenom="Paul";
        System.out.println("Recherche des personnes sur le prenom "+rechPrenom);
        l.stream().filter((p)->p.getPrenom().equals(rechPrenom)).forEach((o)->System.out.println(o));


        System.out.println("--------- age max des personnes");
        int maxAge = l.stream().mapToInt((p)->p.getAge()).max().getAsInt();
        System.out.println("Max age = " + maxAge);

        System.out.println("--------- Si on utilise 2 fois un meme Stream");
        IntStream intS = l.stream().mapToInt((p)->p.getAge());
        maxAge = intS.max().getAsInt();
        System.out.println("Max age = " + maxAge);

        try{
            maxAge = intS.max().getAsInt();
            System.out.println("Max age = " + maxAge);
        }catch(Exception ex){System.out.println(ex);}

    }
}

