package fr.cnam.projet;

import java.util.*;
import java.io.*;
import java.net.*;
import java.text.*;
import fr.cnam.ihm.*;

// Classe de definition et de creation d'un client qui se connecte
//   au modele. Ce client se connecte en connaissant le host de la
//   machine sur laquelle le modele s'execute.
//
public class IHMClient implements FormulaireInt
{
    private String     host;       // host de la machine distante
    private int        port;       // port du serveur de socket

    private Formulaire form;      // Le formulaire de l'ihm


    public static void main(String... args)
    {
        int port = Integer.parseInt(args[1]);
        IHMClient ihm = new IHMClient(args[0],port);
    }

    // ------------------------------------------
    // Constructeur
    //    host : host de la machine
    //    port : port du serveur de socket
    // ------------------------------------------
    //
    public IHMClient(String host,int port)
    {
        this.host=host;
        this.port=port;

        // Creation du formulaire
        form = new Formulaire("CLIENT",this,400,200);
        
        //  Creation des elements de l'IHM
        //
        form.addText("CHAINE","Chaine",true,"");
        form.addButton("LISTER","Lister");
        form.addLabel("");

        form.setPosition(200,0);
        form.addZoneText("RESULTATS","Resultats",
                            true,
                            "",
                            150,150);

        // Affichage du formulaire
        form.afficher();
    }

    // ------------------------------------------
    // Methode appellee quand on clique dans un bouton
    // ------------------------------------------
    //
    public void submit(Formulaire form,String nomSubmit)
    {
        try{
            // Lister
            //
            if (nomSubmit.equals("LISTER"))
                {
                    String chaine = form.getValeurChamp("CHAINE");
                    String res = requeteLister(chaine);
                    form.setValeurChamp("RESULTATS",res);
                }

        }catch(Exception ex){form.setValeurChamp("RESULTATS","ERREUR : "+ex.getMessage());}

    }

    // --------------------------------------------------------------
    // REQUETE : LISTER_ELEMENTS
    //
    // Requete qui demande les elements du modele
    //
    // Retourne le resultat (chaine)
    //
    //   envoi   : LISTER_ELEMENTS (String UTF)
    //           : chaine (String UTF)
    //   recu    : resultat (String UTF)
    // ------------------------------------------
    //
    public String requeteLister(String chaine) throws Exception
    {
        Socket soc = new Socket(host,port);
        InputStream is = soc.getInputStream();
        OutputStream os = soc.getOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        DataInputStream dis = new DataInputStream(is);
        
        // Ecriture de la requete
        //
        dos.writeUTF("LISTER_ELEMENTS");
        dos.writeUTF(chaine);
        
        // Lecture de la reponse
        //
        String resultat = dis.readUTF();
        
        soc.close(); // C'est le client qui ferme le socket
        
        return resultat;
    }

}