package fr.cnam.projet;

import java.util.*;

import fr.cnam.ihm.*;

// Classe de definition de l'ihm du modele
//
public class IHMModele implements FormulaireInt
{
    private Modele     modele; // Le modele
    private Formulaire form;   // Le formulaire

    // Constructeur
    //
    public IHMModele(Modele modele)
    {
        this.modele = modele;

        // Creation du formulaire
        form = new Formulaire("Exemple",this,400,200);
        
        //  Creation des elements de l'IHM
        //
        form.addText("ELEMENT","Element",true,"");
        form.addButton("AJOUTER","Ajouter");
        form.addLabel("");
        form.addText("INFO","Info",false,"");

        // Creation de la zone de resultat
        //
        form.setPosition(200,0);
        form.addZoneText("RESULTATS","Resultats",
                            true,
                            "",
                            150,150);

        // Affichage de l'IHM
        //
        form.afficher();
    }

    // Methode appellee quand on clique dans un bouton
    //
    public void submit(Formulaire form,String nomSubmit)
    {
        // Ajouter une chaine dans la liste des elements du modele
        //
        if (nomSubmit.equals("AJOUTER"))
            {
                modele.ajouter(form.getValeurChamp("ELEMENT"));
                form.setValeurChamp("RESULTATS",modele.lister());
            }
    }

    // Methode qui met a jour l'ihm en fonction d'un message
    //  d'information provenant du client
    //
    public void setInfo(String chaine)
    {
        System.out.println("INFO: "+chaine);
        form.setValeurChamp("INFO",chaine);
    }
}