package fr.cnam.projet;

import java.util.*;
import java.io.*;
import java.text.*;

import fr.cnam.util.*;

// Classe de definition du modele
//
public class Modele
{
    private ArrayList<String> elements; // Une liste de chaine
    private String info;                // Un texte d'information
    private IHMModele ihm;              // L'IHM du modele

    // Contructeur
    //
    public Modele()
    {
        // Creation de la liste
        elements = new ArrayList<String>();
        info = "";
    }

    // Ajoute une chaine dans la liste
    //
    public void ajouter(String valeur)
    {
        elements.add(valeur);
    }

    // Liste les elements
    //
    public String lister()
    {
        String res="";
        for(String e:elements)
            res=res+e+"\n";

        return res;
    }

    // Mise a jour de l'ihm du modele en fonction
    //  d'une chaine envoye par le client
    //
    public void setInfo(String chaine)
    {
        ihm.setInfo(chaine);
    }

    // Pour faire connaitre l'IHM du modele au modele
    //
    public void setIhm(IHMModele ihm)
    {
        this.ihm=ihm;
    }

}