package fr.cnam.projet;

import java.io.*;

// Classe de definition d'un thread qui prend en charge le traitement
//  d'une requete cliente.
//  
public class RequeteThread extends Thread
{
    String requete;
    DataInputStream dis;
    DataOutputStream dos;
    Modele modele;

    // Constructeur
    //
    public RequeteThread(String requete,DataInputStream dis,DataOutputStream dos,
                         Modele modele)
    {
        this.requete=requete;
        this.dis=dis;
        this.dos=dos;
        this.modele=modele;
    }
    
    // Traitement de la requete en parralele des autres requetes clientes
    //
    public void run()
    {
        try{
            // --------------------------------------------------------------
            // REQUETE : LISTER_ELEMENTS
            //
            // Requete qui liste les elements su serveur
            //
            //
            //   recu   : (String UTF) chaine  afficher sur le serveur
            //
            //   envoye : (String UTF) les elements
            //
            if (requete.equals("LISTER_ELEMENTS"))
                {
                    String chaine = dis.readUTF();
                    System.out.println("CHAINE: "+chaine);
                    String resultat = modele.lister();
                    modele.setInfo(chaine);

                    dos.writeUTF(resultat);
                }
        }
        catch(Exception ex)
            {
                System.out.println("ERREUR REQUETE : "+requete);
                ex.printStackTrace();
            }
    }
}