package fr.cnam.projet;

import java.io.*;
import java.net.*;
import java.util.*;

// Classe de definition du serveur de socket qui prend
//  en entree le modele.
// Son role :
//    - recevoir des requetes
//    - en fonction de la requete appelle une methode du modele
//    - retourner le resultat
//
// Les syntaxes des requetes acceptees sont decrites ci-dessous.
//
public class ServeurSocketModele
{
    // Contructeur
    //   Le serveur de socket est execute dans le constructeur
    //   Il prend en entree le port de communication
    //   Il prend en entree le compte
    //
    public ServeurSocketModele(int port,Modele modele)
    {
        try{
            // Creation du serveur de socket
            //
            ServerSocket ssoc;
            ssoc = new ServerSocket(port);
            
            // Boucle sur l'acceptation d'un socket
            //
            while(true)
                {
                    // Attente d'acceptation d'un socket
                    //
                    System.out.println("En attente...");
                    Socket soc = ssoc.accept();
                    // Un socket a etabli une communication
                    System.out.println("Socket accepte");
                    
                    // Recuperation des flots de lecture et d'ecriture du socket
                    //
                    InputStream is = soc.getInputStream();
                    OutputStream os = soc.getOutputStream();
                    DataInputStream dis = new DataInputStream(is);
                    DataOutputStream dos = new DataOutputStream(os);
                    
                    // Lecture de l'entete de la requete
                    //
                    System.out.println("Lecture du socket");
                    String requete = (String)(dis.readUTF());
                    System.out.println("REQUETE: "+requete);

                    // Lancement d'un thread de traitement de la requete
                    // Ceci permet de traiter en parallele plusieurs requetes
                    //  provenant de clients differents
                    //
                    RequeteThread rt = new RequeteThread(requete,dis,dos,modele);
                    
                    rt.start();

                }
        }catch(Exception ex){};
        
	  }
}
