import java.io.*;
import java.awt.*;
import java.net.*;
import java.util.*;

import fr.cnam.ihm.*;

// Classe d'ihm de gestion d'un talker qui permet
//  d'envoyer un message a un autre talker qui serait present
//  sur le reseau
//
public class IhmTalk implements FormulaireInt
{
  private Formulaire form;      // Le formulaire d'ihm
  private String texte;         // Texte affiche dans la zone d'historique
  private Vector<String> list;  // liste ihm des host:port
  private int portCurrent;      // port courant utilise par le talker de cet ihm
  private int portLocal;        // port local utilise par le talker de cet ihm
  private String ipEcouteur;    // adresse ip du talker courant
  private int portEcouteur;     // port du talker courant

  private ArrayList<String> hosts;     // Les noms des hosts des talkers potentiels
  private ArrayList<Integer> ports;    // Les ports des talkers potentiels

  // Constructeur
  //
  public IhmTalk(int portCurrent,int portLocal,ArrayList<String> hosts,
                 ArrayList<Integer> ports) throws Exception
  {
    // Initialisation par defaut des attributs
    //
    this.texte="";
    this.list=new Vector<String>();
    this.portCurrent=portCurrent;
    this.portLocal=portLocal;
    this.hosts=hosts;
    this.ports=ports;
    this.ipEcouteur=null;

    // Creation du formualire d'ihm et des elements d'ihm
    //
    form = new Formulaire("TALKER",this,430,300);

    form.addButton("PINGS","Rafraichir");
    form.addListScroll("TALKERS",
                       "Talkers",
                       true,
                       null,
                       200,200);
    form.addText("ECOUTEUR","Discussion avec:",false,"");
    form.addText("MESSAGE","Message",true,"");
    form.addButton("ENVOYER","Envoyer");
    form.setPosition(210,0);
    form.addZoneText("zone","Historique",false,"",200,200);
    
    form.desactiver("MESSAGE");
    form.desactiver("ENVOYER");

    try{form.afficher();}catch(Exception ex){}
    
  }// Constructeur

  // Methode qui essaye de communiquer avec chacune des machines/ports
  //  passes en parametre du programme
  //
  public void pings()
  {
    for(int port:ports)
      for(String h:hosts)
        {
          if ( (h.equals("localhost"))&&(port==portCurrent) ) continue;

          Thread thread = new Thread(){
                                           public void run(){try{
          
          try{
            Socket soc;
            if (portLocal==0)
              soc = new Socket(InetAddress.getByName(h),port);
            else
              {
                soc = new Socket(Inet4Address.getByName(h),port,
                                 Inet4Address.getLocalHost(),portLocal);
                soc.setSoLinger(true,0);
              }
            OutputStream os=soc.getOutputStream();
            DataOutputStream dos=new DataOutputStream(os);
            InputStream is=soc.getInputStream();
            DataInputStream dis=new DataInputStream(is);
            dos.writeUTF(TalkMain.PING);
            String reponse = dis.readUTF();
            if (reponse.equals(TalkMain.IDENT_TALK))
              {            
                // Ne pas ajouter si existe deja dans la liste
                String adr=h+":"+port;
                if (! list.contains(adr)) 
                  {
                    // Ajout dans la liste et maj de l'ihm
                    list.add(h+":"+port);
                    form.setListData("TALKERS",list.toArray(new String[0]));
                  }
                soc.close();
              }
          }catch(Exception ex)
            {
              /*
              // Si impossible de communiquer avec un talker sur le reseau et
              //  qu'il etait present dans la liste alors le supprimer de la liste
              //
              String adr = h+":"+port;
              System.out.println(">>> "+adr+" "+ex);
              int index = list.indexOf(adr);
              if (index!=-1) list.remove(index);
              form.setListData("TALKERS",list.toArray(new String[0]));
              */
            }
                                             }catch(Exception ex2){}; }};
          thread.start();
        }
  }
        
  // Ajout d'un texte dans la zone d'historique
  //
  public void add(String str)
  {
    texte=texte+"\n"+str;
    form.setValeurChamp("zone",texte);
  }

  // Action dans un des elements de l'IHM
  //
  public void submit(Formulaire form,String nomSubmit)
  {
    // Rafraichir la liste en essayant de "pinguer" les machines
    //
    if (nomSubmit.equals("PINGS"))
      {
        pings();
      }

    // Action quand on clique sur un des talkers present dans la liste
    //  des adresses IP+port
    //
    if (nomSubmit.equals("TALKERS"))
      {
        String ip = form.getValeurChamp("TALKERS");
        if(!ip.equals(""))
          {
            String[] t=ip.split("[:]",2);
            // On memorise l'adresse IP+port selectionne
            ipEcouteur = t[0];
            portEcouteur = Integer.parseInt(t[1]);
            // On met a jour l'ihm permettant d'envoyer une message
            form.setValeurChamp("ECOUTEUR",ip);
            form.activer("MESSAGE");
            form.activer("ENVOYER");
          }
      }

    // Action quand on envoie un message a un talker
    //
    if (nomSubmit.equals("ENVOYER"))
      {
        // Si un talker a ete selectionne
        //
        if (ipEcouteur!=null)
          {
            try{
              // On ouvre un socket pour y ecrire le message
              String mess = form.getValeurChamp("MESSAGE");
              Socket soc;
              if (portLocal==0)
                soc = new Socket(InetAddress.getByName(ipEcouteur),portEcouteur);
              else
                {
                  soc = new Socket(Inet4Address.getByName(ipEcouteur),portEcouteur,
                                   Inet4Address.getLocalHost(),portLocal);
                  soc.setSoLinger(true,0);
                }
              OutputStream os=soc.getOutputStream();
              InputStream is = soc.getInputStream();
              DataOutputStream dos=new DataOutputStream(os);
              DataInputStream dis = new DataInputStream(is);
              dos.writeUTF(ipEcouteur+":\n"+mess);
              dis.readUTF();
              soc.close();
            }catch(Exception ex)
              {
                // Si exception alors le talker avec qui on echange s'est deconnecte
                //
                add(ipEcouteur+"\nn'est plus accessible");
                ipEcouteur=null;
                form.desactiver("MESSAGE");
                form.desactiver("ENVOYER");
              }
          }
      }
  }

}//class