import java.io.*;
import java.awt.*;
import java.net.*;
import java.util.*;
import java.util.stream.*;

import fr.cnam.ihm.*;

// Programme principal qui cree l'ihm du talker et cree un Server de Socket
//  qui est a l'ecoute des autres talkers
//
public class TalkMain
{
  static public final String IDENT_TALK = "IDENT TALK OK";
  static public final String PING = "PING";

  public static void main(String args[]) throws Exception
  {
    // Syntaxe de la ligne de commande d'execution
    //    port [portLocal] [h1 h2 ... ] [: p1 p2 ..]
    //
    // port      : le port utilise pour le serveur de socket
    // portLocal : le port  local utilise pour ouvrir un socket.
    // Si portLocal==0 alors on laisse l'OS pour designer ce port
    // Sinon c'est ce port qui est utilise pour ouvrir un socket.
    //     Dans ce cas on met en place une politique de securite
    //     de l'utilisation des ports : 
    //           - voir java.policy de  -Djava.security.policy=java.policy
    //
    // hi        : ce sont les noms des hosts utilises sur le reseau
    // pi        : ce sont les ports utilises par les serveurs de sockets du reseau
    // 
    // Seul le premier parametre est obligatoire.
    //
    // En absence des autres parametres les valeurs par defaut sont :
    //    portLocal = 0
    //    hi        = localhost
    //    pi        = 9100 9101 9102
    //
    int port;
    int portLocal;
    ArrayList<String> hosts = new ArrayList<String>();
    ArrayList<Integer> ports = new ArrayList<Integer>();

    if (args.length==0) 
      {
        System.out.println("Pas de parametre.\nSyntaxe: port [portLocal] [h1 h2 ... ] [: p1 p2 ..]\n");
        System.exit(1);
      }
    if (args.length==1)
      {
        port = Integer.parseInt(args[0]);
        portLocal=0;
        hosts.add("localhost");
        ports.add(9100);
        ports.add(9101);
        ports.add(9102);
      }
    else //parametres > 2
      {
        port = Integer.parseInt(args[0]);
        portLocal = Integer.parseInt(args[1]);

        // Parcours des hosts et ports
        int r=1;  // 1 => hosts   2 => ports
        for(int i=2;i<args.length;i++) 
          {
            if ((r==1)&&(!args[i].equals(":"))) hosts.add(args[i]);
            if (r==2) ports.add(Integer.parseInt(args[i]));
            if (args[i].equals(":")) r=2;
          }
        // Si apres le parcours pas de hosts ou pas de ports
        if (hosts.size()==0) hosts.add("localhost");
        if (ports.size()==0) 
          {
            ports.add(9100);
            ports.add(9101);
            ports.add(9102);
          }
      }
    
    // Si portLocal==0 alors pas de securite a prendre en compte
    //
    if (portLocal!=0)
      System.setSecurityManager(new SecurityManager());

    //Creation de l'ihm
    //
    IhmTalk ihm = new IhmTalk(port,portLocal,hosts,ports);

    // Creation du serveur de socket
    //  qui ajoute dans l'ihm le texte recu sauf si "PING" est recu.
    // Le PING est utilise pour verifier si un talker est present sur
    //  le reseau
    //
    String str;
    ServerSocket ssoc;
    ssoc = new ServerSocket(port);
    
    while(true)
      {
        System.out.println("En attente sur "+port);
        Socket soc = ssoc.accept();
        InputStream is = soc.getInputStream();
        OutputStream os = soc.getOutputStream();
        DataInputStream dis = new DataInputStream(is);
        DataOutputStream dos = new DataOutputStream(os);
        str = dis.readUTF();
        if (str.equals(PING))
          {
            dos.writeUTF(IDENT_TALK);
          }
        else
          {
            ihm.add(str); // Ajout dans l'ihm du texte recu
            dos.writeUTF("OK");
          }
      }
  }
}
