package fr.cnam.etrevivant;

import java.util.Random;

import fr.cnam.multiagent.*;

// Classe de dfinition d'un cafard.
// Un cafard a qu'une vie (hrite de EtreVivantMultiple)
//  mais il est difficile  tuer. Il a une 
//  probabilit de mourir de 1/10
// 
public class Cafard extends EtreVivantMultiple
{
    private Random rnd;    // La fonction alatoire 

    // Constructeur
    public Cafard(String nom)
    {
        super(nom);
        this.rnd = new Random();
        genre = "Cafard";
    }

    // On surcharge la mthode "tuer" de la classe hrite afin
    //   de spcialiser le traitement "tuer".
    //
    // Si le cafard n'est pas mort alors
    //  on dcrmente son nombre de vie que si alatoirement 
    //   on tire le chiffre 9 entre 0 et 9 (proba = 1/10)
    //
    public void tuer()
    {
        if (this.nbVies>=1) 
            {
                int n = this.rnd.nextInt(10);
                if (n==9)
                    this.nbVies--;
            }
    }
}