package fr.cnam.etrevivant;

import fr.cnam.multiagent.Agent;

// La classe EtreVivant est la classe racine de notre conception.
// Elle regroupe les attributs communs  tous les tres vivants.
// La classe est asbtraite car crer une instance de cette classe n'a
// pas de sens et parcequ'elle n'implmente qu'uen partie de l'interface
// Agent.
//
public abstract class EtreVivant implements Agent
{
    private String nom;   // Le nom de l'etre vivant

    protected String genre; // La nature de l'etre vivant (ex: Chat, Humain, ...)
    // Cet atttibut est protected car les classes hritantes (Chat, Humain, ...) 
    //  renseigne cet attribut

    // Constructeur (appel depuis les classes hritantes
    public EtreVivant(String nom)
    {
        this.nom   = nom;
        this.genre = "Inconnu"; // Valeur par dfaut.
        // C'est les classes reles qui surchargeront cet attribut avec
        //  la valeur correspondante
    }

    // Le genre
    public String genre()
    {
        return genre;
    }

    // Le nom 
    public String nom()
    {
        return nom;
    }
    
}