package fr.cnam.etrevivant;

// Cette classe dfinit les tres vivants qui ont un nombre de vies
//   et un nombre max de vie.
// Elle hrite de la classe EtreVivant.
// Les classes Chat, Chien et Cafard hritent de cette classe.
//
public abstract class EtreVivantMultiple extends EtreVivant
{
    protected int    nbVies;    // Le nombre de vie courant
    protected int    maxVies;   // Le nombre max de vie

    // Constructeur
    public EtreVivantMultiple(String nom)
    {
        super(nom);
        nbVies = 1;  // Par defaut (cas de la classe Cafard)
        maxVies = 1; // Par defaut (cas de la classe Cafard)
    }

    // ========== Implmentation de l'interface Agent
    // ======================================================

    // Un chat est vivant si son nombre de vie est >=1
    public boolean estVivant()
    {
        if (this.nbVies>=1)
            return true;
        else
            return false;
    }

    // Retourne le nombre de vie
    public int nbVies()
    {
        return nbVies;
    }

    // Tuer un chat consiste  dcrmenter son nombre de vie
    public void tuer()
    {
        if (this.nbVies>=1) this.nbVies--;
    }

    // Ressusciter un chat consiste a lui redonner son nombre max de vie 
    public void ressusciter()
    {
        this.nbVies = this.maxVies;
    }
}