import java.io.*;
import java.util.*;

public class Exercice09_3
{
    // Si il y a une erreur d'IO non prvue dans le main
    //  on retourne l'erreur (le programme s'arrte et affichera
    //  l'exception
    //
    public static void main(String[] args) throws IOException
    {
        // Recuperation de l'entre du clavier
        BufferedReader clavier = new BufferedReader(new InputStreamReader(System.in));
        
        // Lecture du nom du fichier
        System.out.println("Le nom du fichier de livre : ");
        String nomFichierEntree = clavier.readLine();
        File fichIn = new File(nomFichierEntree);
        if (! fichIn.exists())
            {
                System.out.println("Le fichier d'entree n'existe pas");
                System.exit(0);
            }

        // Le flot de lecture
        BufferedReader flotIn = new BufferedReader(new InputStreamReader(new FileInputStream(fichIn)));


        // Dclaration du ArrayList contennant les livres
        ArrayList<Livre> livres = new ArrayList<Livre>();
        
        // On va lire le fichier texte.
        //

        // Lecture du nombre de livre
        String str = flotIn.readLine();
        int nbLivre=0;
        try{
            nbLivre = Integer.parseInt(str);
        }catch(Exception ex)
            {
                System.out.println("Pb de lecture du nbre de livre a la ligne 1 :["+str+"]");
                System.exit(0);
            }
        
        // Lecture de chaque livre
        int ligne=2;
        for(int i=0;i<nbLivre;i++)
            try{
                // Cration d'un livre vide
                Livre l = new Livre();

                // Lecture des 3 lignes
                // Ajout des informations lues dans le livre
                // C'est la classe Livre qui dcode la ligne lue
                // On passe en parametre le numero de ligne car
                //  si il y a un pb de decodage la mthode setInfo
                //  pourra indiquer l'erreur.
                //
                String str1 = flotIn.readLine();
                l.setInfo(str1,ligne);
                ligne++;

                String str2 = flotIn.readLine();
                l.setInfo(str2,ligne);
                ligne++;

                String str3 = flotIn.readLine();
                l.setInfo(str3,ligne);
                ligne++;

                // Ajout du livre dans la liste
                livres.add(l);

            }catch(IOException ex) {
                System.out.println("Erreur dans la lecture d'un livre.");
                System.out.println("Erreur  la ligne "+ ligne);
            }

        // On affiche les livres
        System.out.println("====================================");
        for(Livre l:livres)
            System.out.println(l+"\n-------------------");

    }
}

// La classe Livre

class Livre
{
    String titre;              // Le titre du livre
    String description;        // La description du livre
    ArrayList<String> auteurs; // Les auteurs du livre

    // Constructeur
    public Livre()
    {
        // La liste est cree vide
        auteurs = new ArrayList<String>();
    }
    // Methode qui initialise l'attribut du livre en fonction de
    //  la ligne du fichier
    // On passe le numero de la ligne en parametre en cas d'erreur
    //
    public void setInfo(String info,int ligne)
    {
        try{
            // Les champs de la ligne sont spars par ":"
            StringTokenizer strTok = new StringTokenizer(info,":");

            String typeInfo = strTok.nextToken().trim();
            // La methode trim permet d'enlever les blancs superflus

            if (typeInfo.equals("TITRE"))
                {
                    this.titre = strTok.nextToken().trim();
                }
            else if (typeInfo.equals("DESCRIPTION"))
                {
                    this.description = strTok.nextToken().trim();
                }
            else if (typeInfo.equals("AUTEURS"))
                {
                    while(strTok.hasMoreTokens())
                        {
                            this.auteurs.add(strTok.nextToken().trim());
                        }
                }
            else
                {
                    // Erreur qui sera traite dans le bloc d'exception
                    throw new Exception("Type info inconnue: ["+typeInfo+"]");  
                }

        }catch(Exception ex)
            {
                System.out.println(ex);
                System.out.println("Erreur de format  la ligne: ["+ligne+"]");
                System.out.println(info);
            }
    }

    // Le livre en chaine
    public String toString()
    {
        // On concatene les auteurs
        String auteursStr="";
        for(String a:this.auteurs)
            auteursStr=auteursStr+a+"   ";

        return 
            this.titre + "\n" +
            this.description + "\n" +
            auteursStr;
    }
}