import java.io.*;

public class Exercice09_1
{
    // Si il y a une erreur d'IO non prvue dans le main
    //  on retourne l'erreur (le programme s'arrte et affichera
    //  l'exception
    //
    public static void main(String[] args) throws IOException
    {
        // Recuperation de l'entre du clavier
        BufferedReader clavier = new BufferedReader(new InputStreamReader(System.in));
        
        /// Lecture du nom du fichier
        System.out.println("Le nom du fichier texte : ");
        String nomFichierEntree = clavier.readLine();
        File fichIn = new File("text",nomFichierEntree);
        if (! fichIn.exists())
            {
                System.out.println("Le fichier d'entree n'existe pas");
                System.exit(0);
            }
        BufferedReader flotIn = new BufferedReader(new InputStreamReader(new FileInputStream(fichIn)));

        // Cration du rpertoire "binaire"
        File rep = new File("binaire");
        rep.mkdir(); // Si le repertoire existe dj cette mthode ne fait rien

        // Dclaration du fichier de sortie
        //
        String nomFichierSortie = "binaire"+File.separator+
            nomFichierEntree+".binaire";
        File fichOut = new File(nomFichierSortie);

        DataOutputStream flotOut = new DataOutputStream(new FileOutputStream(fichOut));
        
        // On va lire le fichier texte ligne  ligne et
        //  nous allons crire la ligne dans un fichier binaire
        //
        try{
            String str = flotIn.readLine();
            while (str!=null)
                {
                    System.out.println("trace: "+str);
                    flotOut.writeUTF(str);
                    str = flotIn.readLine();
                    // Attention on crit pas le "\n" qui a t absorb 
                    //  par le readLine.
                }
            flotOut.close();
            System.out.println("Fichier cree : "+nomFichierSortie);
        }
        catch(IOException ex)
            {
                // Si erreur d'criture alors on trace l'erreur
                System.out.println(ex);
                ex.printStackTrace();
            }
    }
}
