package fr.cnam.rdv;

import java.util.*;
import java.io.*;

// Cette classe abstraite est la définition d'un élément de l'agenda.
//  Les classes RendezVous et Tache héritent de cette classe et implémentent
//   les méthodes abstraites utilisées dans les traitements génériques de
//   la classe Agenda
//
// Cette classe implémente l'interface Comparable afin de pouvoir trier
//  les éléments de l'agenda
//
//    
public abstract class ElementAgenda implements Comparable<ElementAgenda>
{
    // Tous les éléments d'un agenda ont un texte
    protected String texte;

    // Le constructeur
    public ElementAgenda(String texte)
    {
        this.texte = texte;
    }

    // ---- Les méthodes abstraites -------

    // Méthode qui permet de savoir si un élément est pour un jour donné
    abstract public boolean siDansLaPeriode(Calendar jour);

    // Méthode qui permet d'ordonner les éléments
    // Elle retourne 
    //   dans le cas d'un RendezVous la date sous la forme d'un entier 
    //   dans le cas d'une Tache la priorite ou la date butée sous la forme d'un entier
    //
    abstract long getOrdre();
    
    // -------------------------------------

    // Méthode qui permet de modifier sous formm d'IHM un élément de l'agenda
    // Cette méthode doit être surchargée par chaque classe 
    //   RendezVous RendezVousPeriodique Tache
    // 
    public void modifierIhm()
    {
        System.out.println("L'ihm n'est pas implementee");
    }

    // Méthode d'implémentaiton de l'interface Comparable
    //  utilisé pour trier les éléments de l'agenda
    // Cette méthode utilise la méthode getOrdre qui est implémentée par
    //  chacune des classes RendezVous et Tache
    //
    public int compareTo(ElementAgenda e2)
    {
        if (this.getOrdre()<e2.getOrdre())
            return -1;
        else if (this.getOrdre()>e2.getOrdre())
            return +1;
        else
            return 0;
    }

    abstract public void ecrire(DataOutputStream dos) throws Exception;

    abstract public void lire(DataInputStream dis) throws Exception;
}