package fr.cnam.rdv;

import java.lang.*;
import java.util.*;
import java.io.*;

import fr.cnam.rdv.*;
import fr.cnam.ihm.*;

// Classe qui crée une IHM permettant de gérer l'agenda
// Elle implémente l'interface FormulaireInt afin de réaliser
//  les actions dans l'IHM
//
public class IHMAgenda implements FormulaireInt
{
    private Agenda agenda;  // L'agenda
    
    // Le constructeur qui crée les objets de l'IHM
    //
    public IHMAgenda(Agenda agenda) throws Exception
    {
        int x,y;

        // Initialisation des attributs
        this.agenda = agenda;

        // Date courante (utilisé par défaut dans l'IHM)
        Calendar calActuel = Calendar.getInstance();
        int dj = calActuel.get(Calendar.DAY_OF_MONTH)+1;
        int dm = calActuel.get(Calendar.MONTH)+1;
        int dy = calActuel.get(Calendar.YEAR);
        String dateActuelle = String.format("%s/%s/%s",dj,dm,dy);
        
        // Création du formulaire
        Formulaire form = new Formulaire("AGENDA",this,false,800,600);

        // Pour gérer les fichiers
        form.addText("NOM_FICHIER_DATA","Nom du fichier",true);
        form.addButton("OUVRIR","Ouvrir",-1,-1,200);
        form.addButton("ENREGISTRER","Enregistrer",-1,-1,200);
        y = form.getYCour();
        form.addText("NOM_FICHIER_IMPORT_RDVS","Fichier texte de rdvs",true,"",-1,-1,180,5,150);
        form.addButton("IMPORTER_RDVS","Importer",340,y,100);
        y = form.getYCour();
        form.addText("NOM_FICHIER_IMPORT_TACHES","Fichier texte de taches",true,"",0,-1,180,5,150);
        form.addButton("IMPORTER_TACHES","Importer",340,y,100);

        // Création des zones de texte permettant d'ajouter un nouveau rendez-vous
        form.addLabel("Pour ajouter un rendez vous",10,200,200);
        form.addText("DATE_RDV","Date",true,"",-1,-1,150,5,50);
        form.addText("HEURE_DEBUT_RDV","Heure de debut",true,"",-1,-1,150,5,50);
        form.addText("HEURE_FIN_RDV","Heure de fin",true,"",-1,-1,150,5,50);
        form.addText("TEXTE","Texte",true,"",-1,-1,150,5,100);
        form.addButton("AJOUTER_RDV","Ajouter");
        y = form.getYCour();

        // Création de la zone de texte permettant d'afficher le contenu
        //  de l'agenda ou les informations d'erreur
        //
        form.addZoneText("RESULTAT","Resultat",true,agenda.toString(),450,30,400,500);


        // Création du bouton permettant d'afficher tout l'agenda
        form.addLabel("Pour afficher le contenu de l'agenda",10,y+30,300);
        form.addButton("TOUT_AGENDA","Tout l'agenda",-1,-1,200);
        y = form.getYCour();

        // Création des objets permettant de faire l'action
        //  qui affiche les éléments d'un jour donné
        form.addLabel("Pour afficher les rdv d'un jour",10,y+30,300);
        form.addText("JOUR","Date",true,dateActuelle,-1,-1,50,0,100);
        form.addButton("JOUR_AGENDA","Valider",-1,-1,100);
        y = form.getYCour();

        // Création des objets permettant de faire l'action
        //  qui permet de modifier un élement donné
        form.addLabel("Pour modifier un element",10,y+30,300);
        form.addText("NUMERO","Numero",true,"",-1,-1,50,0,50);
        form.addButton("MODIFIER","Modifier",-1,-1,100);

        // Affichage de l'IHM
        form.afficher();
    }


    // Méthode qui est appelé par l'IHM quand on clique dans un bouton
    // Cette méthode a en entrée le formulaire et le nom du bouton
    //
    public void  submit(Formulaire form,String nomSubmit)
    {
        // ACTION : ajouter un nouveau rendez-vous
        // ----------------------------------------------
        if (nomSubmit.equals("AJOUTER_RDV"))
            {
                Calendar cal = Agenda.stringToCalendar(form.getValeurChamp("DATE_RDV"));
                if (cal==null)
                    form.setValeurChamp("RESULTAT","Erreur de saisi dans la date");
                else
                    {
                        agenda.ajouterElement(new RendezVous(form.getValeurChamp("DATE_RDV"),
                                                             form.getValeurChamp("HEURE_DEBUT_RDV"),
                                                             form.getValeurChamp("HEURE_FIN_RDV"),
                                                             form.getValeurChamp("TEXTE")));
                        form.setValeurChamp("RESULTAT",agenda.toString());
                    }
            }

        // ACTION : affiche le contenu de tout l'agenda
        // ----------------------------------------------
        if (nomSubmit.equals("TOUT_AGENDA"))
            {
                form.setValeurChamp("RESULTAT",agenda.toString());
            }

        // ACTION : affiche les éléments d'un jour donné
        // ----------------------------------------------
        if (nomSubmit.equals("JOUR_AGENDA"))
            {
                String sj = form.getValeurChamp("JOUR");
                Calendar cal = Agenda.stringToCalendar(sj);
                if (cal==null)
                    form.setValeurChamp("RESULTAT","ERREUR: la date n'est pas bonne");
                else 
                    form.setValeurChamp("RESULTAT",agenda.agendaJour(cal));
            }

        // ACTION : modifier un des éléments de l'agenda
        // ----------------------------------------------
        if (nomSubmit.equals("MODIFIER"))
            {
                String snum = form.getValeurChamp("NUMERO");
                int num = Integer.parseInt(snum);
                agenda.getElement(num).modifierIhm();
            }

        // ACTION : ouvrir un fichier d'agenda
        // ----------------------------------------------
        if (nomSubmit.equals("OUVRIR"))
            {
                String nomFichier = form.getValeurChamp("NOM_FICHIER_DATA");
                if (nomFichier.equals(""))
                    {
                        form.setValeurChamp("RESULTAT","Le champ est vide");
                    }
                else
                    {
                        try{
                            agenda.ouvrir(nomFichier);
                            form.setValeurChamp("RESULTAT",agenda.toString());
                        }
                        catch(Exception ex)
                            {
                                StringWriter sw = new StringWriter();
                                sw.write("Pb dans l'ouverture ou le chargement du fichier\n");
                                ex.printStackTrace(new PrintWriter(sw));
                                form.setValeurChamp("RESULTAT",sw.toString());

                            }
                    }
            }

        if (nomSubmit.equals("ENREGISTRER"))
            {
                String nomFichier = form.getValeurChamp("NOM_FICHIER_DATA");
                if (nomFichier.equals(""))
                    {
                        form.setValeurChamp("RESULTAT","Le champ est vide");
                    }
                else
                    {
                        try{
                            agenda.enregistrer(nomFichier);
                            form.setValeurChamp("RESULTAT","Agenda sauvegarde dans "+nomFichier);
                        }
                        catch(Exception ex)
                            {
                                StringWriter sw = new StringWriter();
                                sw.write("Pb d'enregistrement de l'agenda\n");
                                ex.printStackTrace(new PrintWriter(sw));
                                form.setValeurChamp("RESULTAT",sw.toString());
                            }
                    }
            }

        if (nomSubmit.equals("IMPORTER_RDVS"))
            {
                String nomFichier = form.getValeurChamp("NOM_FICHIER_IMPORT_RDVS");
                if (nomFichier.equals(""))
                    {
                        form.setValeurChamp("RESULTAT","Le champ est vide");
                    }
                else
                    {
                        try{
                            agenda.importerRdvs(nomFichier);
                            form.setValeurChamp("RESULTAT",agenda.toString());
                        }
                        catch(Exception ex)
                            {
                                StringWriter sw = new StringWriter();
                                sw.write("Pb d'import du fichier\n");
                                ex.printStackTrace(new PrintWriter(sw));
                                form.setValeurChamp("RESULTAT",sw.toString());
                            }
                    }
                
            }

        if (nomSubmit.equals("IMPORTER_TACHES"))
            {
                String nomFichier = form.getValeurChamp("NOM_FICHIER_IMPORT_TACHES");
                if (nomFichier.equals(""))
                    {
                        form.setValeurChamp("RESULTAT","Le champ est vide");
                    }
                else
                    {
                        try{
                            agenda.importerTaches(nomFichier);
                            form.setValeurChamp("RESULTAT",agenda.toString());
                        }
                        catch(Exception ex)
                            {
                                StringWriter sw = new StringWriter();
                                sw.write("Pb d'import du fichier\n");
                                ex.printStackTrace(new PrintWriter(sw));
                                form.setValeurChamp("RESULTAT",sw.toString());
                            }
                    }
                
            }
        
    }
}