package fr.cnam.tetris;

import fr.cnam.grille.*;

public class DeplacerForme extends Thread
{
    private int posXCurrent;
    private int posYCurrent;
    private Tetris tetris;
    private boolean finDuJeu;
    private boolean finDeplacement;
    private FormeTetris fc;
    private GrilleIHM grille;
    private int tempo;

    public DeplacerForme(Tetris tetris)
    {
        this.tetris = tetris;
        this.fc = null;
        this.grille = tetris.getGrilleIhm();
        this.tempo = tetris.getTempo();
    }

    public void abandonner()
    {
        finDeplacement=true;
        finDuJeu=true;
    }
    
    public void aGauche()
    {
        if (fc==null) return;
        if (posXCurrent>-5) 
            {
                 fc.desafficher(grille,posXCurrent,posYCurrent);
                 if (fc.siAffichable(grille,posXCurrent-1,posYCurrent))
                     {
                         posXCurrent--;
                         fc.afficher(grille,posXCurrent,posYCurrent);
                     }
                 else
                     fc.afficher(grille,posXCurrent,posYCurrent);
            }
    }

    public void aDroite()
    {
        if (fc==null) return;
        if (posXCurrent<tetris.getNbColonne()-1) 
            {
                fc.desafficher(grille,posXCurrent,posYCurrent);
                if (fc.siAffichable(grille,posXCurrent+1,posYCurrent))
                     {
                         posXCurrent++;
                         fc.afficher(grille,posXCurrent,posYCurrent);
                     }
                else
                    fc.afficher(grille,posXCurrent,posYCurrent);
            }
    }

    public void tourner()
    {
        if (fc==null) return;
        fc.desafficher(grille,posXCurrent,posYCurrent);
        fc.nextPixmap();
        if (fc.siAffichable(grille,posXCurrent,posYCurrent))
            fc.afficher(grille,posXCurrent,posYCurrent);
        else
            {
                fc.previousPixmap();
                fc.afficher(grille,posXCurrent,posYCurrent);
            }
    }

    public void descendre()
    {
        if (fc==null) return;
        if (posYCurrent<tetris.getNbLigne()-1)
            {
                fc.desafficher(grille,posXCurrent,posYCurrent);
                if (fc.siAffichable(grille,posXCurrent,posYCurrent+1))
                     {
                         posYCurrent++;
                         fc.afficher(grille,posXCurrent,posYCurrent);
                     }
                else
                    fc.afficher(grille,posXCurrent,posYCurrent);
            }
    }

    public void tomber()
    {
        if (fc==null) return;
        tempo=10;
    }

    public void run()
    {
        try{
            
            finDuJeu = false;
            posXCurrent = tetris.getNbColonne()/2-2;
            posYCurrent = 0;
            while (! finDuJeu)
                {
                    fc = tetris.getFactoryFormes().getFormeAleatoire();
                    if (fc.siAffichable(grille,posXCurrent,posYCurrent))
                        {
                            finDeplacement = false;
                            tempo = tetris.getTempo();
                            while (! finDeplacement)
                                {
                                    fc.afficher(grille,posXCurrent,posYCurrent);
                                    try{Thread.sleep(tempo);}catch(Exception ex){};
                                    fc.desafficher(grille,posXCurrent,posYCurrent);
                                    if (fc.siAffichable(grille,posXCurrent,posYCurrent+1))
                                        posYCurrent++;
                                    else
                                        {
                                            fc.afficher(tetris.getGrilleIhm(),posXCurrent,posYCurrent);
                                            finDeplacement=true;
                                            posXCurrent = tetris.getNbColonne()/2-2;
                                            posYCurrent = 0;
                                        }
                                }
                        }
                    else
                        {
                            finDuJeu=true;
                            fc=null;
                        }
                }

        }
        catch(Exception ex)
            {
                ex.printStackTrace();
            }
    }
}