package fr.cnam.tetris;

import java.util.*;

public class FactoryFormesTetris
{
    private ArrayList<FormeTetris> formes;
    private Random rnd;

    public FactoryFormesTetris()
        {
            formes = new ArrayList<FormeTetris>();
            rnd = new Random();
        }

    public FormeTetris getFormeAleatoire()
    {
        int index = rnd.nextInt(formes.size());

        return formes.get(index);
    }


    // index d'une forme
    public void addForme(int index,int taille,String pixmapStr)
    {
        int[][] pixmap = new int[taille][taille];
        
        int x=0;
        int y=0;
        for(int i=0;i<pixmapStr.length();i++)
            {
                if ( (i!=0) && (i%taille==0)) {x=0;y++;}
                pixmap[x][y] = Integer.parseInt(""+pixmapStr.charAt(i));
                x++;
            }
        formes.get(index).addPixmap(pixmap);
    }

    public int creerForme(int couleur)
    {
        FormeTetrisImpl forme = new FormeTetrisImpl(couleur);
        formes.add(forme);
        return formes.size()-1;
    }

    public ArrayList<FormeTetris>  getFormes()
    {
        return formes;
    }
}