package fr.cnam.tetris;

import java.util.*;

import fr.cnam.grille.*;

public class FormeTetrisImpl implements FormeTetris
{
    private int couleur;
    private ArrayList<int[][]> pixmaps;
    private int current;

    public FormeTetrisImpl(int couleur)
        {
            this.couleur = couleur;
            pixmaps = new ArrayList<int[][]>();
            current=0;
        }


    // ========= implementation de l'interface FormeTetris =======

    public void addPixmap(int[][] pixmap)
    {
        current=0;
        pixmaps.add(pixmap);
    }
    public int getCouleur()     {return couleur;}

    public int getNbPixmap() {return pixmaps.size();}

    public int[][] getPixmap(int index) { return pixmaps.get(index);}

    public void initCurrent() {current=0;}

    public void nextPixmap() 
    {
        current = (current + 1 ) % pixmaps.size();
    }

    public void previousPixmap() 
    {
        if (current==0) current =  pixmaps.size()-1;
        else current--;
    }

    public void afficher(GrilleIHM grille,int posX,int posY)
    {
        int[][] pixmap = pixmaps.get(current);
        for(int x=0;x<pixmap[0].length;x++)
            for(int y=0;y<pixmap.length;y++)
                {
                    try{
                        if (pixmap[x][y]==1)
                            grille.setMarque(couleur,x+posX,y+posY);
                    }catch(Exception ex){} //On peut deborder
                }
    }

    public void desafficher(GrilleIHM grille,int posX,int posY)
    {
        int[][] pixmap = pixmaps.get(current);
        for(int x=0;x<pixmap[0].length;x++)
            for(int y=0;y<pixmap.length;y++)
                {
                    try{
                        if (pixmap[x][y]==1)
                            grille.setMarque(0,x+posX,y+posY);
                    }catch(Exception ex){} //On peut deborder
                }
    }

    public boolean siAffichable(GrilleIHM grille,int posX,int posY)
    {
        int[][] pixmap = pixmaps.get(current);
        for(int x=0;x<pixmap[0].length;x++)
            for(int y=0;y<pixmap.length;y++)
                {
                    try{
                        if ( (pixmap[x][y]==1) && (grille.getMarque(x+posX,y+posY)!=0) )
                            return false;
                    }catch(Exception ex){if(pixmap[x][y]==1) return false;} //On peut deborder
                }
        return true;
    }

}

