package fr.cnam.tetris;

import java.util.*;
import java.awt.*;
import java.awt.event.*;

import fr.cnam.tetris.*;
import fr.cnam.grille.*;

public class Tetris implements GrilleControlesInt
{
    private FactoryFormesTetris factoryFormes;
    private int nbLigne;
    private int nbColonne;
    private GrilleIHM grille;
    private DeplacerForme deplacement;
    private int tempo;

    public Tetris(int nbColonne,int nbLigne)
    {
        this.nbLigne = nbLigne;
        this.nbColonne = nbColonne;
        this.tempo = 500;
        factoryFormes = new FactoryFormesTetris();
        
        int index;
        index = factoryFormes.creerForme(9);
        factoryFormes.addForme(index,5,"0000000100001000010001100");
        factoryFormes.addForme(index,5,"0000010000111100000000000");
        factoryFormes.addForme(index,5,"0011000100001000010000000");
        factoryFormes.addForme(index,5,"0000000000011110000100000");

        index = factoryFormes.creerForme(8);
        factoryFormes.addForme(index,5,"0000000100001000010000110");
        factoryFormes.addForme(index,5,"0000000000111101000000000");
        factoryFormes.addForme(index,5,"0110000100001000010000000");
        factoryFormes.addForme(index,5,"0000000001011110000000000");

        index = factoryFormes.creerForme(2);
        factoryFormes.addForme(index,5,"0010000100001000010000100");
        factoryFormes.addForme(index,5,"0000000000111110000000000");
        factoryFormes.addForme(index,5,"0010000100001000010000100");
        factoryFormes.addForme(index,5,"0000000000111110000000000");

        index = factoryFormes.creerForme(7);
        factoryFormes.addForme(index,5,"0000000000011100001000000");
        factoryFormes.addForme(index,5,"0000000100001000110000000");
        factoryFormes.addForme(index,5,"0000001000011100000000000");
        factoryFormes.addForme(index,5,"0000000110001000010000000");
        
        index = factoryFormes.creerForme(5);
        factoryFormes.addForme(index,5,"0000000000011100010000000");
        factoryFormes.addForme(index,5,"0000000100011000010000000");
        factoryFormes.addForme(index,5,"0000000100011100000000000");
        factoryFormes.addForme(index,5,"0000000100001100010000000");
        
        index = factoryFormes.creerForme(6);
        factoryFormes.addForme(index,5,"0000000010011100000000000");
        factoryFormes.addForme(index,5,"0000000100001000011000000");
        factoryFormes.addForme(index,5,"0000000000011100100000000");
        factoryFormes.addForme(index,5,"0000001100001000010000000");

        index = factoryFormes.creerForme(3);
        factoryFormes.addForme(index,5,"0000010000111110000100000");
        factoryFormes.addForme(index,5,"0011000100001000010001100");
        factoryFormes.addForme(index,5,"0000010000111110000100000");
        factoryFormes.addForme(index,5,"0011000100001000010001100");

        grille = GrilleIHM.creerGrilleIhmDansFrame(nbColonne,nbLigne,10,50,50);
        grille.setNomBouton(1,"START");
        grille.setNomBouton(2,"GAUCHE");
        grille.setNomBouton(3,"DROITE");
        grille.setNomBouton(4,"TOURNER");
        grille.setNomBouton(5,"DESCENDRE");
        grille.setNomBouton(6,"TOMBER");

        // L'acteur des boutons de la grille est le jeu de tetris
        grille.setActeur(this);

        deplacement = new DeplacerForme(this);
        
    }

    public int getNbLigne(){return nbLigne;}
    public int getNbColonne(){return nbColonne;}
    public GrilleIHM getGrilleIhm(){return grille;}
    public int getTempo(){return tempo;}
    
    public FactoryFormesTetris getFactoryFormes()
    {
        return factoryFormes;
    }

    public void action(int numBouton,GrilleIHM ihm)
    {
        if (numBouton==1)
            {
                deplacement.abandonner();
                try{Thread.sleep(1000);}catch(Exception ex){};
                grille.effacerGrille();
                deplacement = new DeplacerForme(this);
                deplacement.start();
            }

        if (numBouton==2)
            deplacement.aGauche();

        if (numBouton==3)
            deplacement.aDroite();

        if (numBouton==4)
            deplacement.tourner();

        if (numBouton==5)
            deplacement.descendre();

        if (numBouton==6)
            deplacement.tomber();
    }



    public static void main(String... args)
    {
        Tetris jeu = new Tetris(20,30);
    }
}