// Correction de l'exercice 15 : trier les fleuves geographiques
//  3 criteres de tri : nom, longueur et lieu
//
//
import java.util.*;

public class Exercice15
{
    // Programme principale
    //
    public static void main(String... args)
    {
        // Creation des fleuves dans une collection
        //
        ArrayList<Fleuve> fleuves = new ArrayList<Fleuve>();
        fleuves.add(new Fleuve("Loire",1012,"France"));
        fleuves.add(new Fleuve("Rhone",812,"France"));
        fleuves.add(new Fleuve("Garonne",647,"France"));
        fleuves.add(new Fleuve("Rhin",1325,"France"));
        fleuves.add(new Fleuve("Nil",6700,"Afrique"));
        fleuves.add(new Fleuve("Congo",4700,"Afrique"));
        fleuves.add(new Fleuve("Mississipi",6275,"Amerique du Nord"));
        fleuves.add(new Fleuve("Mekong",4350,"Asie"));
        fleuves.add(new Fleuve("Danube",3020,"Europe"));
        fleuves.add(new Fleuve("Niger",4184,"Afrique"));
        fleuves.add(new Fleuve("Vaal",1212,"Afrique"));
        fleuves.add(new Fleuve("Gila",1015,"Amerique du Nord"));
        
        // Tri sur le nom croissant
        //
        System.out.println("-----------------------------------");
        System.out.println("Iri sur le nom");
        Collections.sort(fleuves);
        for(Fleuve f:fleuves)
            System.out.println(f);

        // Tri sur la longueur decroissante
        //
        System.out.println("-----------------------------------");
        System.out.println("Tri sur la longueur decroissante");
        Collections.sort(fleuves,new TrierParLongueur() );
        for(Fleuve f:fleuves)
            System.out.println(f);

        
        // Tri sur le lieu
        // Pour un meme lieu, tri sur la longueur decroissante
        //
        System.out.println("-----------------------------------");
        System.out.println("Tri sur le lieu");
        Collections.sort(fleuves,new TrierParLieu() );
        for(Fleuve f:fleuves)
            System.out.println(f);

        
    }
}

// Classe de defintion d'un fleuve qui implemente
// l'interface Comparable
//
class Fleuve implements Comparable<Fleuve>
{
    private String nom;
    private int longueur;
    private String lieu;

    public Fleuve(String nom,int longueur,String lieu)
    {
        this.nom=nom;
        this.longueur=longueur;
        this.lieu=lieu;
    }
    
    public String getNom(){return nom;}
    public int getLongueur(){return longueur;}
    public String getLieu(){return lieu;}

    public String toString()
    {
        return String.format("%-20s%6d%20s",nom,longueur,lieu);
    }

    // Methode de comparaison des fleuves
    // suivant le nom croissant
    //
    public int compareTo(Fleuve f)
    {
        return nom.compareTo(f.getNom());
    }
}

// Classe de definition du critere de tri suivant
//  la longeur decroissante
//
class TrierParLongueur implements Comparator<Fleuve>
{
    public int compare(Fleuve f1,Fleuve f2)
    {
        if (f1.getLongueur() > f2.getLongueur())
            return -1;
        else return 1;
    }
}

// Classe de definition du critere de tri suivant
//  le lieu croissant et pour un meme lieu suivant
//  la longueur decroissante
//
class TrierParLieu implements Comparator<Fleuve>
{
    public int compare(Fleuve f1,Fleuve f2)
    {
        int c1 = f1.getLieu().compareTo(f2.getLieu());
        if (c1<0) return -1;
        else if (c1>0) return 1;
        else // lieux egaux alors on tri par longueur decroissante
            {
                if (f1.getLongueur() > f2.getLongueur())
                    return -1;
                else return 1;
            }
    }
}
