// Impl&eacute;mentation d'un ensemble de chaine par hritage de ListeString


public class Exercice16
{
    public static void main(String args[]) 
    {
        // Pour finir le programme
        boolean fini = false;

        // Creation de l'ensemble
        EnsembleString ensemble = new EnsembleString(); 
        
        // Activation des traces de la classe
        EnsembleString.trace = true; 

        // Traitement qui affiche un menu pour chacun des cas de test
        //
        while (!fini){

            // Le mnenu est affiche
            Terminal.ecrireStringln("-----------------");
            Terminal.ecrireStringln("1 : void add(String s)");
            Terminal.ecrireStringln("2 : int size()");
            Terminal.ecrireStringln("3 : String get(int indice)");
            Terminal.ecrireStringln("4 : void set(int indice, String valeur)");
            Terminal.ecrireStringln("5 : int indexOf(String occurrence)");
            Terminal.ecrireStringln("6 : indexOf(int debut, String occurrence)");
            Terminal.ecrireStringln("7 : boolean remove(int indice)");
            Terminal.ecrireStringln("8 : initialisation de l'ensemble");
            Terminal.ecrireStringln("9 : afficher l'ensemble");
            Terminal.ecrireStringln("0 : exit");
            Terminal.ecrireStringln("-----------------");
            afficherEnsemble(ensemble);
            Terminal.ecrireStringln("-----------------");

            // Saisir le choix
            Terminal.ecrireString("Choix: ");
            int choix = Terminal.lireInt();
            
            // Les cas de test
            switch(choix)
                {
                case 0 : 
                    {
                        // Sortir du programme
                        fini=true;
                        break;
                    }

                case 1:
                    {
                        // Ajout d'un element
                        Terminal.ecrireString("s = ");
                        String s = Terminal.lireString();
                        ensemble.add(s);
                        break;
                    }
                case 2:
                    {
                        // Taille de la ensemble
                        int taille = ensemble.size();
                        Terminal.ecrireStringln("Taille = "+taille);
                        break;
                    }
                case 3:
                    {
                        // Acces a un element de la ensemble
                        Terminal.ecrireString("indice = ");
                        int indice = Terminal.lireInt();
                        //
                        String valeur = ensemble.get(indice);
                        if (valeur!=null) Terminal.ecrireStringln("get = "+valeur);
                        else Terminal.ecrireStringln("Incorrect");
                        break;
                    }

                case 4:
                    {
                        // Changer un element de la ensemble
                        Terminal.ecrireString("indice = ");
                        int indice = Terminal.lireInt();
                        Terminal.ecrireString("valeur = ");
                        String valeur = Terminal.lireString();
                        //
                        boolean res = ensemble.set(indice,valeur);
                        if (res) Terminal.ecrireStringln("Correct");
                        else Terminal.ecrireStringln("Incorrect");
                        break;
                    }
                case 5:
                    {
                        // Rechercher un element a partir d'un indice
                        Terminal.ecrireString("valeur = ");
                        String valeur = Terminal.lireString();
                        //
                        int index = ensemble.indexOf(valeur);
                        Terminal.ecrireStringln("index = "+index);
                        break;
                    }
                case 6:
                    {
                        // Rechercher un element a partir d'un indice
                        Terminal.ecrireString("debut = ");
                        int debut = Terminal.lireInt();

                        Terminal.ecrireString("valeur = ");
                        String valeur = Terminal.lireString();
                        //
                        int index = ensemble.indexOf(debut,valeur);
                        Terminal.ecrireStringln("index = "+index);
                        break;
                    }
                case 7:
                    {
                        // Suppression d'un element
                        Terminal.ecrireString("indice = ");
                        int indice = Terminal.lireInt();
                        //
                        boolean res = ensemble.remove(indice);
                        if (res) Terminal.ecrireStringln("Correct");
                        else Terminal.ecrireStringln("Incorrect");
                        break;
                    }
                case 8:
                    {
                        // Initialisation de la ensemble avec des valeurs fixes
                        //  (afin d'alleger le travail du testeur)
                        //
                        ensemble = new EnsembleString();
                        ensemble.add("Zoe");
                        ensemble.add("Lafont");
                        ensemble.add("Dupont");
                        ensemble.add("Flament");
                        ensemble.add("Durand");
                        break;
                    }
                case 9:
                    {
                        for(int i=0;i<ensemble.size();i++)
                            {
                                Terminal.ecrireStringln(i + ":" + ensemble.get(i));
                            }
                    }
                }
        }

    }

    /** Methode interne qui affiche le contenu de la ensemble 
        @param l la ensemble &agrave; afficher
    */
    static void afficherEnsemble(EnsembleString l)
    {
        Terminal.ecrireStringln("L'ensemble:");
        if (l==null) return;
        for(int i=0;i<l.size();i++)
            Terminal.ecrireStringln(i + ":" + l.get(i));
    }
}