
/** Classe de d&eacute;finition d'une liste de String.<br>
    Cette classe permet d'ajouter des &eacute;l&eacute;ments (qui sont des String) sans limite de capacit&eacute;.<br>
    Elle utilise un tableau tab[] en interne dont la dimension est de MAX.<br>
    Lors d'un ajout d'&eacute;l&eacute;ment, si le tableau est satur&eacute; alors tab[] est redimensionn&eacute; &agrave; sa taille + MAX.
 */
public class ListeString
{
    /** Tableau de chaine contenant les &eacute;l&eacute;ments de la liste */
    private String[] tab ;

    /** Nombre d'&eacute;l&eacute;ment de la liste (taille de la liste) */
    private int nb;

    /** Nombre max d'&eacute;l&eacute;ments allou&eacute;s &agrave; chaque tranche. MAX = 5*/
    private final static int MAX = 5;

    /** Taille physique du tableau */
    private int taillePhysique;

    /** Pour activer les traces (Faire ListeString.trace = true).<br> Par defaut est à false */
    static public boolean trace = false;

    /**
       Constructeur qui cr&eacute;e une liste de chaine vide.<br>
       Le tableau interne de la liste est dimensionn&eacute; &agrave; MAX.
    */
    public ListeString()
    {
        tab = new String[MAX];
        nb = 0;
        taillePhysique = MAX;
    }

    /**
       ajout d'un &eacute;l&eacute;ment dans la liste
       @param s chaine ajout&eacute;e dans la liste
    */
    public void add(String s)
    {
        if (nb==taillePhysique)
            {
                // Il faut allouee une nouvelle tranche
                taillePhysique = tab.length+MAX;
                //
                String[] tmp = new String[taillePhysique];
                for(int i=0;i<nb;i++) tmp[i]=tab[i];
                tab = tmp;
                //
                // ou un code plus court:
                // tab = Arrays.copyOf(tab,taillePhysique);
                // Ne pas oublier d'ajouter le import java.util.* dans ce cas;
                //
                // Trace
                if (trace)
                    System.out.println("Nouvelle taille physique : "+tab.length);

                // Ajout du nouvel element
                tab[nb] = s;
                nb++;
            }
        else
            {
                // Ajout du nouvel element
                tab[nb] = s;
                nb++;
            }
    }

    /**
       Retourne la taille de la liste (nombre d'&eacute;l&eacute;ment)
    */
    public int size()
    {
        return nb;
    }

    /**
       Retourne l'&eacute;l&eacute;ment &agrave; l'indice donn&eacute;
       @param indice indice de l'&eacute;l&eacute;ment retourn&eacute;
       @return l'&eacute;l&eacute;ment se trouvant &agrave; l'indice donn&eacute;.<br>null si indice incorrect
    */
    public String get(int indice)
    {
        if (indice <0) return null;
        if (indice > nb-1) return null;
        return tab[indice];
    }

    /**
       Change un &eacute;l&eacute;ment de la liste
       @param indice indice de l'element (de 0 a size()-1)
       @param valeur valeur de changement de l'element
       @return false si indice incorrect sinon true
    */
    public boolean set(int indice, String valeur)
    {
        if (indice <0) return false;
        if (indice > nb-1) return false;
        tab[indice] = valeur;
        return true;
    }

    /**
       Recherche un element dans la liste
       @param occurence valeur &agrave; rechercher
       @return retourn l'indice de l'element trouv&eacute; sinon retourne -1
    */
    public int indexOf(String occurence)
    {
        for(int i=0;i<size();i++) {
            if (tab[i].equals(occurence))
                return i;
        }
        return -1;
    }        

    /**
       Recherche un element dans la liste &agrave; partir d'un indice
       @param debut indice de d&eacute;but de la recherche
       @param occurence valeur &agrave; rechercher
       @return retourn l'indice de l'element trouve sinon retourne -1
    */
    public int indexOf(int debut,String occurence)
    {
        if (debut <0) return -1;
        if (debut > nb-1) return -1;
        for(int i=debut;i<size();i++) {
            if (tab[i].equals(occurence))
                return i;
        }
        return -1;
    }        
        
    /**
       Supprimer un element
       @param indice indice de l'element &agrave; supprimer
       @return false si indice incorrect sinon true
    */
    public boolean remove(int indice)
    {
        if (indice <0) return false;
        if (indice > nb-1) return false;
        for(int i=indice;i<=nb-2;i++) {
            tab[i]=tab[i+1];
        }
        nb=nb-1;
        return true;
    }

}