package fr.cnam.projet;

// La classe Musique qui hrite de la classe MultiMedia 
//
public class Musique extends MultiMedia
{
  private String[] chansons;
  private String   genre;
  private int duree;

  // Constructeur par defaut
  public Musique(){}

  // Le constructeur complet qui prend en entre les attributs de la
  // classe Musique mais aussi les attributs de la classe hrite
  //
public Musique(String ident,String description,String titre,
               String[] chansons, String genre, int duree)
  {
    super(ident,description,titre);
    this.chansons = chansons;
    this.genre = genre;
    this.duree = duree;
  }

  // Mthode qui retourne en chaine une musique et qui appelle 
  //  explicitement la mthode toString de la classe hrite 
  //  afin d'avoir les informations compltes de la musique et de ses 
  //  attributs hrits
  public String toString()
  {
    String a="";
    for(String s:chansons)
      a=a+String.format("%-15s : %s\n","chanson",s);
    return 
      super.toString() + a +
      String.format("%-15s : %s\n","genre",genre)+
      String.format("%-15s : %s\n","duree",duree+"");
  }

  // Duree de l'emprunt d'un livre
  //
  public int getDureeEmprunt()
  {
    return 15;
  }
    
  // Format court d'un livre
  //
  public String formatCourt()
  {
    return description + " " + titre ;
  }

  // Decodage
  //
  public void decoder(String ligne)
  {
    String[] champs = ligne.split("[;]",7);
    ident = champs[1];
    description = champs[2];
    titre = champs[3];
    chansons = decoderChansons(champs[4]);
    genre = champs[5];
    duree = Integer.parseInt(champs[6]);
  }

  private String[] decoderChansons(String chansons)
  {
    String[] champs = chansons.split("[/]");
    return champs;
  }
}
    
