package fr.cnam.projet;

import java.util.*;
import fr.cnam.util.*;
import java.lang.reflect.*;

// Classe de gestion d'un bibliotheque de media
//
public class Bibliotheque
{
    // La collection polymorphe de  media
    private ArrayList<MultiMedia> elements;
    
    // Constructeur
    public Bibliotheque()
    {
        elements = new ArrayList<MultiMedia>();
        
        initialiser();
    }

    // Ajouter un media a la collection
    public void ajouter(MultiMedia media)
    {
        elements.add(media);
    }

    // get element
    //
    public MultiMedia get(int i){return elements.get(i);}
    
    //nb element
    public int getNb(){return elements.size();}

    // Tous les medias (pour affichage)
    public String getTousLesMedias()
    {
        String res="";
        for(MultiMedia m:elements)
            {
                res=res+"-----------------\n";
                res=res+m.toString();
            }
        return res;
    }

    // Tous les medias d'un type de media
    //
    public String getCatalogue(String typeMedia)
    {
        String res="";
        for(MultiMedia m:elements)
            if (m.getClass().getName().equals(typeMedia))
                res=res+m.formatCourt()+"\n";
        return res;
    }

    // Les medias qui doivent etre rendus
    public String getMediaEmpruntDepasse()
    {
        String res="";
        for(MultiMedia m:elements)
            {
                if ( m.getDateEmprunt() != null)
                    {
                        long d = m.getDateEmprunt().getTimeInMillis()/86400000;
                        long now = System.currentTimeMillis()/86400000;
                        if (now-d > m.getDureeEmprunt())
                            {
                              res=res+m.formatCourt()+"\n";
                            }
                    }
            }
        return res;
    }


    // Pour ne pas etre oblige de creer des lignes fastidieuses
    //  dans le main pour creer des livres, films et jeux
    //  on lit un fichier texte qui contient pour chaque ligne
    //  un media
    //
    private void initialiser()
    {
        String[] lignes = Terminal.lireFichierTexte("../data/Biblio.txt");
        
        for(String ligne : lignes)
            {
                String[] type = ligne.split("[;]");
                
                try{
                  Class<?> classe = Class.forName(type[0]);
                  Constructor constr = classe.getConstructor();
                  MultiMedia m  = (MultiMedia)constr.newInstance();
                  m.decoder(ligne);
                  ajouter(m);
                }catch(Exception ex){ex.printStackTrace();System.out.println(ex);}
            }
    }
    
}