package fr.cnam.projet;

// La classe Film qui hrite de la classe MultiMedia 
//
import java.util.*;
import fr.cnam.ihm.*;

public class Film extends AbstractMultiMedia
{
    private String   realisateur;
    private ArrayList<String> acteurs;
    private String   genre;
    private boolean  coffret;

    //Constructeur par defaut
    public Film(){
      this.typeMedia= "FILM";
      this.realisateur = "";
      this.acteurs = new ArrayList<String>();
      this.genre = "";
      this.coffret = false;
    }

  // Le constructeur complet qui prend en entre les attributs de la
  // classe Film mais aussi les attributs de la classe hrite
  //
  public Film(String description,String titre,
              String realisateur, ArrayList<String> acteurs, String genre, boolean coffret)
  {
    super("FILM",description,titre);
    this.realisateur = realisateur;
    this.acteurs = acteurs;
    this.genre = genre;
    this.coffret = coffret;
  }

  // Mthode qui retourne en chaine un livre et qui appelle 
  //  explicitement la mthode toString de la classe hrite 
  //  afin d'avoir les informations compltes du film et de ses 
  //  attributs hrits
  public String toString()
  {
    String a="";
    for(String s:acteurs)
      a=a+String.format("%-15s : %s\n","acteur",s);
    return 
      super.toString() + 
      String.format("%-15s : %s\n","realisateur",realisateur)+
      String.format("%-15s : %s\n","genre",genre)+
      a +
      String.format("%-15s : %s\n","coffret",coffret+"")
      ;
  }

  // Champs de saisi
  //
  public void saisir(Formulaire form)
  {
    super.saisir(form);
    form.addText("REALISATEUR", "Ralisateur", true, "");
    form.addText("ACTEUR", "Acteur", true, "");
    form.addButton("AJOUTER ACTEUR","Ajouter acteur");
    form.addText("ACTEURS AJOUTES","",false,"");
  }

  // Validaiton de la saisie
  //
  public void valider(Formulaire form,String action)
  {
    realisateur=form.getValeurChamp("REALISATEUR");
    if (action.equals("AJOUTER ACTEUR"))
      {
        acteurs.add(form.getValeurChamp("ACTEUR"));
        String str="";for(String s:acteurs)str=str+s+";";
        form.setValeurChamp("ACTEURS AJOUTES",str);
      }
    super.valider(form,action);
  }
  

  // Duree de l'emprunt d'un film
  //
  public int getDureeEmprunt()
  {
    if (coffret) return 30;
    return 7;
  }

  // Format court d'un film
  //
  public String formatCourt()
  {
    return titre + " / " + genre;
  }

  // Decodage
  //
  public void decoder(String ligne)
  {
    String[] champs = ligne.split("[;]",7);
    description = champs[1];
    titre = champs[2];
    realisateur = champs[3];
    genre = champs[4];
    acteurs = decoderActeurs(champs[5]);
    if (champs[6].equals("coffret")) coffret=true;
    else coffret=false;
  }

  private ArrayList<String> decoderActeurs(String acteurs)
  {
    String[] champs = acteurs.split("[/]");
    return new ArrayList<String>(Arrays.asList(champs));
  }

}
    
