package fr.cnam.projet;

import fr.cnam.ihm.*;
import java.util.*;

// La classe Livre qui hrite de la classe MultiMedia 
//
public class Livre extends AbstractMultiMedia
{
  private ArrayList<String> auteurs;
  private String   edition;
  private String   genre;
  private int      tome;

  // Constructeur par defaut
  public Livre(){
    super();
    this.typeMedia= "LIVRE";
    this.auteurs = new ArrayList<String>();
    this.edition = "";
    this.genre = "";
    this.tome = 0;
  }

  // Le constructeur complet qui prend en entre les attributs de la
  // classe Livre mais aussi les attributs de la classe hrite
  //
  public Livre(String description,String titre,
               ArrayList<String> auteurs, String edition, String genre, int tome)
  {
    super("LIVRE",description,titre);
    this.auteurs = auteurs;
    this.edition = edition;
    this.genre = genre;
    this.tome = tome;
  }

  // Mthode qui retourne en chaine un livre et qui appelle 
  //  explicitement la mthode toString de la classe hrite 
  //  afin d'avoir les informations compltes du livre et de ses 
  //  attributs hrits
  public String toString()
  {
    String a="";
    for(String s:auteurs)
      a=a+String.format("%-15s : %s\n","auteur",s);
    return 
      super.toString() + a +
      String.format("%-15s : %s\n","edition",edition)+
      String.format("%-15s : %s\n","genre",genre)+
      String.format("%-15s : %s\n","tome",tome+"");
  }

  // Champs de saisi
  //
  public void saisir(Formulaire form)
  {
    super.saisir(form);
    form.addText("AUTEUR", "Auteur", true, "");
    form.addButton("AJOUTER AUTEUR","Ajouter auteur");
    form.addText("AUTEURS AJOUTES","",false,"");
  }

  // Validation de la saisie
  //
  public void valider(Formulaire form,String action)
  {
    if (action.equals("AJOUTER AUTEUR"))
      {
        auteurs.add(form.getValeurChamp("AUTEUR"));
        String str="";for(String s:auteurs)str=str+s+";";
        form.setValeurChamp("AUTEURS AJOUTES",str);
      }
    super.valider(form,action);
  }
  

  // Duree de l'emprunt d'un livre
  //
  public int getDureeEmprunt()
  {
    if (genre.equals("roman"))
      return 60;
    if (genre.equals("magazine"))
      return 15;
    return 30;
  }
    
  // Format court d'un livre
  //
  public String formatCourt()
  {
    return titre + " de " + auteurs.get(0);
  }

  // Decodage
  //
  public void decoder(String ligne)
  {
    String[] champs = ligne.split("[;]",7);
    description = champs[1];
    titre = champs[2];
    auteurs = decoderAuteurs(champs[3]);
    edition = champs[4];
    genre = champs[5];
    tome = Integer.parseInt(champs[6]);
  }

  private ArrayList<String> decoderAuteurs(String auteurs)
  {
    String[] champs = auteurs.split("[/]");
    return new ArrayList<String>(Arrays.asList(champs));
  }
}
    
