package fr.cnam.projet;

// La classe Media : class commune  tous les mdias d'uen mdiathque 
//
import java.util.*;
import fr.cnam.ihm.*;

abstract public class AbstractMultiMedia implements MultiMedia
{
  protected String typeMedia;      // Type du media
  protected int id;                // Identification unique d'un media
  protected String description;    // Description gnrale du media
  protected String titre;          // Le titre du media
  protected Calendar dateEmprunt;  // date d'emprunt

  // Constructeur par defaut
  public AbstractMultiMedia(){
    this.typeMedia    ="";
    this.id        =  -1;
    this.description  = "";
    this.titre        = "";
    this.dateEmprunt = null;
  }

  // Constructeur complet du media
  public AbstractMultiMedia(String typeMedia,String description,String titre)
  {
    this.typeMedia    = typeMedia;
    this.description  = description;
    this.titre        = titre;
    this.dateEmprunt = null;  // Par defaut, pas d'emprunt
  }

  // Mthode qui retourne en chaine le media
  //
  public String toString()
  {
    String str = ">>>> "+typeMedia+"\n";
    str = str + String.format("%-15s : %s\n","id",this.id);
    str = str + String.format("%-15s : %s\n","description",
                              this.description);
    str = str + String.format("%-15s : %s\n","titre",
                              this.titre);
    str = str + String.format("%-15s : %s\n","duree emprunt",
                              this.getDureeEmprunt());
    if ( this.dateEmprunt !=null)
      str = str + String.format("%-15s : %s\n","date emprunt",
                                this.dateEmprunt.getTime());
    else
      str = str + String.format("%-15s : %s\n","date emprunt",
                                "Le mdia n'est pas emprunt");
    return str;
  }

  // Champs de saisi
  //
  public void saisir(Formulaire form)
  {
    form.addText("DESCRIPTION", "Description ", true, "");
  }

  // Validation de la saisie
  //
  public void valider(Formulaire form,String action)
  {
    description = form.getValeurChamp("DESCRIPTION");
  }


  // Getteurs et Setteurs
  //
  public Calendar getDateEmprunt(){return dateEmprunt;}
  public void setDateEmprunt(Calendar d){dateEmprunt=d;}
  public void setId(int id){this.id=id;}

  // Les methodes abstraites
  //
  // Duree de l'emprunt du media
  abstract public int    getDureeEmprunt();

  // Format court pour affichage sur 1 ligne du media
  abstract public String formatCourt();

  // Le decodage d'un media (ligne texte)
  abstract public void decoder(String ligne);
    
}

