package fr.cnam.projet;

//Exemple du cours sur l'heritage
//
import java.util.*;

import fr.cnam.projet.*;
import fr.cnam.ihm.*;

// Programme principal
//
public class Exemple02 implements FormulaireInt
{
  FactoryBibliotheque factory;

  public Exemple02(){
    factory = new FactoryBibliotheque();

    Formulaire form = new Formulaire("EXEMPLE 02",this,1000,700,true);
    form.addButton("SAISIR LIVRE","Saisir livre");
    form.addButton("SAISIR FILM","Saisir film");
    form.addButton("AFFICHER BIBLIOTHEQUE","Afficher bibliothque");
    form.addButton("AFFICHER EMPRUNTS DEPASSES","Afficher emprunt dpasss");
    form.addButton("TESTER LES EMPRUNTS","Tester les emprunts");
    form.setPosition(400,0);
    form.addZoneText("RESULTAT","",false,"",600,600);
    form.afficher();
  }

  public void submit(Formulaire form, String action) {

    if (action.equals("SAISIR LIVRE"))
      {
        MultiMedia m = factory.getInstanceLivre();
        factory.saisirMedia(m);
      }

    if (action.equals("SAISIR FILM"))
      {
        MultiMedia m = factory.getInstanceFilm();
        factory.saisirMedia(m);
      }


    if (action.equals("AFFICHER BIBLIOTHEQUE"))
      {
        factory.get(0).setDateEmprunt(avant(10));
        factory.get(1).setDateEmprunt(avant(10));
        factory.get(2).setDateEmprunt(avant(10));
        factory.get(3).setDateEmprunt(avant(10));
        factory.get(4).setDateEmprunt(avant(10));
        form.setValeurChamp("RESULTAT",factory.getTousLesMedias());
      }

    if (action.equals("AFFICHER EMPRUNTS DEPASSES"))
      form.setValeurChamp("RESULTAT",factory.getMediaEmpruntDepasse());
    
    if (action.equals("TESTER LES EMPRUNTS"))
      {
        factory.get(0).setDateEmprunt(avant(80));
        factory.get(1).setDateEmprunt(avant(20));
        factory.get(2).setDateEmprunt(avant(40));
        factory.get(3).setDateEmprunt(avant(8));
        factory.get(4).setDateEmprunt(avant(20));
        form.setValeurChamp("RESULTAT",factory.getMediaEmpruntDepasse());
      }
  }

  public static void main(String... args)
  {
    new Exemple02();
  }

  static Calendar avant(int jours)
  {
    Calendar cal = Calendar.getInstance();
    cal.clear();
    cal.setTimeInMillis( System.currentTimeMillis()-(long)jours*86400000);
    return(cal);
  }
}

