package fr.cnam.projet;

import java.util.*;
import fr.cnam.util.*;
import java.lang.reflect.*;

// Classe de gestion d'un factory de multimedia pour toute bibliotheque
//
public class FactoryBibliotheque
{
  //Compteur pour identifier les mdia
  static private int compteur_ident=0;

  // La collection polymorphe de  media
  private ArrayList<AbstractMultiMedia> elements;
    
  // Constructeur
  public FactoryBibliotheque()
  {
    elements = new ArrayList<AbstractMultiMedia>();
        
    initialiser();  // Pour charger des mdias  partir d'un fichier
  }


  // Cration d'un Livre
  //   Attention le livre cr est vide
  //
  public MultiMedia getInstanceLivre(){
    Livre l = new Livre();
    ajouter(l);
    return l;
  }

  // Creation d'un Film
  //  Attention le film cr est"vide"
  //
  public MultiMedia getInstanceFilm(){
    Film l = new Film();
    ajouter(l);
    return l;
  }

  // Saisir dans une IHM un media
  public void saisirMedia(MultiMedia m){
    new IHMMultiMedia((AbstractMultiMedia)m);
  }

  // Ajouter un media a la collection
  private void ajouter(AbstractMultiMedia media)
  {
    media.setId(compteur_ident++);  // Initialisation de l'id du media
    elements.add(media);
  }

  // get element
  //
  public MultiMedia get(int i){return elements.get(i);}
    
  //nb element
  public int getNb(){return elements.size();}

  // Tous les medias (pour affichage)
  public String getTousLesMedias()
  {
    String res="";
    for(AbstractMultiMedia m:elements)
      {
        res=res+"-----------------\n";
        res=res+m.toString();
      }
    return res;
  }


  // Les medias qui doivent etre rendus
  public String getMediaEmpruntDepasse()
  {
    String res="";
    for(AbstractMultiMedia m:elements)
      {
        if ( m.getDateEmprunt() != null)
          {
            long d = m.getDateEmprunt().getTimeInMillis()/86400000;
            long now = System.currentTimeMillis()/86400000;
            if (now-d > m.getDureeEmprunt())
              {
                res=res+m.formatCourt()+"\n";
              }
          }
      }
    return res;
  }


  // Pour ne pas etre oblige de creer des lignes fastidieuses
  //  dans le main pour creer des livres, films et jeux
  //  on lit un fichier texte qui contient pour chaque ligne
  //  un media
  //
  private void initialiser()
  {
    String[] lignes = Terminal.lireFichierTexte("data/Biblio.txt");
        
    for(String ligne : lignes)
      {
        String[] type = ligne.split("[;]");
                
        try{
          Class<?> classe = Class.forName(type[0]);
          Constructor constr = classe.getConstructor();
          AbstractMultiMedia m  = (AbstractMultiMedia)constr.newInstance();
          m.decoder(ligne);
          ajouter(m);
        }catch(Exception ex){ex.printStackTrace();System.out.println(ex);}
      }
  }
    
}