import java.io.*;
import java.net.*;
import java.util.*;

public class ApplicatifServeur
{

  public static void main(String args[])
  {
    int portServeur = Integer.parseInt(args[0]);  // port du serveur
    App a = new App(portServeur);
    a.traitement();
  }
}

// ------------------------------------
class App
{
    private int etat1;
    private ObservableApp obs;

    public App(int portServeur)
    {
        etat1 = 1;
        obs = new ObservableApp(portServeur);
    }

    public void setEtat1(int v)
    {
        etat1 = v;
        obs.notifier(new Integer(etat1));
    }

    public Observable getObservable(){return obs;}

    public void traitement()
    {
        for(int i=0;i<100;i++)
            {
                setEtat1(i);
                System.out.println("setEtat avec "+i);
                System.out.println("------------");
                try{Thread.sleep(1000);}catch(Exception ex){};
            }
    }
}

// ------------------------------------
class ObservableApp extends Observable 
{
  public ObservableApp(int portObservable)
  {
    // Execution d'un thread sur un serveur de socket pour attendre les abonnements
    //  des clients
    try{
      ServerSocket sos = new ServerSocket(portObservable);
      Thread t = new Thread(){
          public void run(){
            while(true){
              try{
                Socket soc = sos.accept();
                InputStream is=soc.getInputStream();
                ObjectInputStream ois=new ObjectInputStream(is);
                String hostNameClient  = (String)(ois.readObject());
                Integer portClient = (Integer)(ois.readObject());

                // Abonnement recu : cration d'un observer ddi au client
                addObserver(new ObserverClient(hostNameClient,portClient.intValue()));
                System.out.println("Abonnement du client fait : "+hostNameClient+" "+portClient);
                soc.close();
              }catch(Exception ex){System.out.println(ex);ex.printStackTrace();}
            }}};
      t.start();
    }catch(Exception ex){};
  }

  public void notifier(Object arg)
  {
    setChanged();
    notifyObservers(arg);
  }
}

// ------------------------------------
// L'observer d'un poste client
//
class ObserverClient implements Observer
{
  String hostNameClient;
  int portClient;

  public ObserverClient(String hostNameClient,int portClient)
    {
      this.hostNameClient = hostNameClient;
      this.portClient = portClient;
    }

    public void update(Observable o,Object arg)
    {
      try{
        // La notification consiste  crire l'objet  notifier sur le socket du poste client
        //
        Socket soc = new Socket(Inet4Address.getByName(hostNameClient),portClient);
        OutputStream os=soc.getOutputStream();
        ObjectOutputStream oos=new ObjectOutputStream(os);
        oos.writeObject(arg);
      }catch(Exception ex){System.out.println(ex);ex.printStackTrace();}
    }
}
