import java.io.*;
import java.net.*;
import java.util.*;

public class Client
{
    public static void main(String[] args)
    {
      // Cration d'un Observable sur le poste (JVM) client.
      // Cet obervable s'est abonn s'abonne au serveur.
      // Il reoit les notifications du serveur.
      // Toute les vues du poste client s'abonnent  cet observable.
      //
      String hostNameServeur = args[0];                   // host du serveur
      int portServeur = Integer.parseInt(args[1]);        // port du serveur
      int portClient= Integer.parseInt(args[2]);          // port du client

      ObservableClient observableDistant = new ObservableClient(hostNameServeur,
                                                                portServeur,
                                                                portClient);

      // Cration des vues
      Utilisateur u1 = new Utilisateur("U1",observableDistant);
      Utilisateur u2 = new Utilisateur("U2",observableDistant);
      Utilisateur u3 = new Utilisateur("U3",observableDistant);
    }
}



// ------------------------------------
class Utilisateur
{
    private ObserverApp observer;
    private String      ident;

    public Utilisateur(String ident,Observable observable)
    {
        this.ident = ident;
        observer = new ObserverApp(this);  // this
        
        observable.addObserver(observer);
    }

    // traitement de utilisateur appelé
    public void traitement(int v)
    {
        System.out.println(ident+" "+v);
    }
}

// ------------------------------------
class ObserverApp implements Observer
{
  Utilisateur util;

  public ObserverApp(Utilisateur util)
  {
    this.util = util;
  }

  public void update(Observable o,Object arg)
  {
    Integer v = (Integer)arg;
    util.traitement(v.intValue()); // APPEL AU TRAITEMENT
  }
}

// ------------------------------------
// LE NOUVEAU OBSERVABLE local qu poste client
// -----------------------------------
class  ObservableClient extends Observable 
{
  public ObservableClient(String hostNameServeur,int portServeur,int portClient)
  {
    try{
      // Abonnement au serveur
      System.out.println("Aboonnement au serveur");
      Socket soc = new Socket(Inet4Address.getByName(hostNameServeur),portServeur);
      OutputStream os=soc.getOutputStream();
      ObjectOutputStream oos=new ObjectOutputStream(os);
      oos.writeObject("localhost");
      oos.writeObject(new Integer(portClient));
      
      // Lancement d'un thread sur un serveur de scoket qui reoit les notifications.
      // Pour chaque notification reu, cet observable notifie les observateurs (les vues)
      //
      ServerSocket sos = new ServerSocket(portClient);
      Thread t = new Thread(){
          public void run()
          {
            while(true)
              {
                try{
                  Socket soc = sos.accept();
                  InputStream is=soc.getInputStream();
                  ObjectInputStream ois=new ObjectInputStream(is);
                  Object obj  = ois.readObject();
                  notifier(obj); // notification
                  soc.close();
                }catch(Exception ex){ System.out.println(ex);ex.printStackTrace();}
              }
          }};
      t.start();
    }catch(Exception ex2){System.out.println(ex2);ex2.printStackTrace();}
  }

  public void notifier(Object arg)
  {
    setChanged();
    notifyObservers(arg);
  }
}

