package fr.cnam.exo1;
/**
   Classe de dfinition d'une phrase.<br>
   Une phrase est avant tout une chane de caractres dont les mots sont espacs par des caractres blancs.
 */
import java.util.*;
import java.io.*;

public class Phrase
{
	// Les attributs de la classe
	//
	private String phrase;             // La String de la phrase
	private ArrayList<String> mots;    // Les mots de la phrase
	private boolean palindrome;        // si la phrase est un palidrome
	private int[] occurences;          // tableau des occurences de a..z de la phrase

	// Methode statique qui demande de saisir une chaine de caractere
	//
	static public String saisirChaine(String invitation) throws IOException  {
		System.out.print(invitation+" : ");
		System.out.flush();
		return new BufferedReader(new InputStreamReader (System.in)) 
				.readLine();
	}

	// Constructeur de la phrase
	//
	public Phrase(String phrase)  {
		this.phrase = phrase;
		isolerMots();
		calculerPalindrome();
		calculerOccurences();
	}

	// Methode qui isole les mots de la phrase
	// Les mots isols sont stocks dans la liste en minuscule
	//
	private void isolerMots()  {
		mots = new ArrayList<String>();
		StringTokenizer strTok = new StringTokenizer(phrase," ',;.-");
		while (strTok.hasMoreTokens()) {
			mots.add(strTok.nextToken().toLowerCase());
		}
	}

	// Initialisation de l'attribut palindrome
	// Dtermine si la phrase est un palindrome
	//
	private void calculerPalindrome() {
		String str1="";
		String str2="";
		for(String s:mots) str1=str1+s;
		for(String s:mots) str2=reverse(s)+str2;

		palindrome = str1.equals(str2);
	}

	// Recherche d'un mot dans la phrase
	//	
	public boolean rechercher(String motARechercher) {
		return mots.contains(motARechercher.toLowerCase());
	}

	// Initialisation de l'attribut occurences
	// Dtermine les occurences des lettres de l'alphabet
	//
	private void calculerOccurences() {
		String phraseLower = phrase.toLowerCase();
		occurences = new int[26];
		for(int i=0;i<26;i++) {
			char c = (char)((int)'a'+i);
			int nb=0;
			for(int k=0;k<phraseLower.length();k++)
				if (phraseLower.charAt(k)==c) nb++;
			occurences[i]=nb;
		}
	}

	// Retourne le nombre d'occurence d'une lettre
	//
	public int getOccurences(char ch) {
		int index = ((int)ch - (int)'a');
		if (index<0 || index>=26) return -1;
		return occurences[index];
	}

	// Concatnation de 2 phrases
	//
	public Phrase concatener(Phrase ph) {
		return new Phrase(phrase+ph.phrase);
	}
	
	// Retourne la chaine de la phrase
	//
	public String getPhrase() {
		return phrase;
	}

	// Retourne les mots de la phrase
	//	
	public ArrayList<String> getMots() {
		return mots;
	}

	// Retourne si la phrase est un palindrome
	//
	public boolean palindrome() {
		return palindrome;
	}

	// Mthode statique interne qui renverse une chane de caractre
	//
	static private String reverse(String str) {
		String res="";
		for(int i=0;i<str.length();i++)
			res=str.charAt(i)+res;
		return res;
	}
}
