package fr.cnam.jeupendu;

import java.util.ArrayList;
import java.util.Random;

import fr.cnam.ihm.Formulaire;
import fr.cnam.ihm.FormulaireInt;
import fr.cnam.util.Terminal;

public class JeuPendu implements FormulaireInt {
	private JeuPenduIHM ihm;
	private String motATrouver;
	private String motAAficher;
	private int nbErreur;
	private String information;

	public JeuPendu() {
		ihm=null;
		motATrouver="";
		motAAficher="";
		nbErreur=0;
		information="";
	}

	public void initMotATrouver(String mot) {
		if (mot.equals("")) information="Erreur de saisi";
		else {
			motATrouver=mot.toUpperCase();
			motAAficher="";
			for(int i=0;i<motATrouver.length();i++)motAAficher=motAAficher+"_";
			nbErreur=0;
			information="Commencer";
			ihm.getForm().setValeurChamp("MOTATROUVER", "");
		}
	}
	
	public void genererMotATrouver() {
		String[] lignes = Terminal.lireFichierTexte("dictionnaire.txt");
		Random rdm = new Random();
		int index = Math.abs(rdm.nextInt())%lignes.length;
		initMotATrouver(lignes[index]);
	}


	public void proposerLettre(String lettre) {
		lettre=lettre.toUpperCase();
		boolean dejaPropose = motAAficher.contains(lettre);
		if (dejaPropose) {
			nbErreur=nbErreur+1;
			if (nbErreur>=7) {
				information="Lettre dj propos et perdu";
				motAAficher=motATrouver;
			}
			else {
				information="Lettre dj propose";
			}
		}
		else if (motATrouver.contains(lettre))
		{
			information="";
			String str="";
			for(int i=0;i<motAAficher.length();i++) {
				if (motATrouver.charAt(i)==lettre.charAt(0))
					str=str+lettre.charAt(0);
				else 
					str=str+motAAficher.charAt(i);
			}
			motAAficher=str;
			if (motAAficher.equals(motATrouver)) {
				information="GAGNE";
			}
		}
		else {
			information="";
			nbErreur=nbErreur+1;
			if (nbErreur>=7) {
				information="PERDU";
				motAAficher=motATrouver;
			}
		}
		ihm.getForm().setValeurChamp("LETTREAPROPOSER", "");
	}

	public void proposerMot(String mot) {
		mot=mot.toUpperCase();
		if (mot.equals(motATrouver)) {
			information="GAGNE";
			motAAficher=motATrouver;
		} else {
			information="PERDU";
			motAAficher=motATrouver;
			nbErreur=7;
		}
	}
	
	@Override
	public void submit(Formulaire form, String action) {
		// TODO Auto-generated method stub

		if(action.equals("VALIDER_MOTATROUVER")) {
			String mot = form.getValeurChamp("MOTATROUVER");
			if (mot.equals("")) information = "Erreur de saisi";
			else initMotATrouver(mot);
		}
		
		if(action.equals("GENERER_MOTATROUVER")) {
			genererMotATrouver();
		}

		if (action.equals("VALIDER_LETTREAPROPOSER")) {
			String lettre = form.getValeurChamp("LETTREAPROPOSER");
			if (lettre.equals("")||lettre.length()>1) information = "Erreur de saisi";
			else proposerLettre(lettre);
		}

		if (action.equals("VALIDER_MOTAPROPOSER")) {
			String mot = form.getValeurChamp("MOTAPROPOSER");
			if (mot.equals("")) information = "Erreur de saisi";
			else proposerMot(mot);
		}

		ihm.notifier();
	}


	public void setIhm(JeuPenduIHM ihm) {
		this.ihm = ihm;
	}

	public String getMotATrouver() {
		return motATrouver;
	}

	public String getMotAAficher() {
		return motAAficher;
	}

	public int getNbErreur() {
		return nbErreur;
	}

	public String getInformation() {
		return information;
	}


}
