package fr.cnam.jeupendu;

import fr.cnam.ihm.CanvasIHM;
import fr.cnam.ihm.Formulaire;

public class JeuPenduIHM {

  // Le Singleton
  private static JeuPenduIHM ihm = null;

  // Accs au singleton
  static public JeuPenduIHM getInstance(){
    if (ihm==null) ihm = new JeuPenduIHM();
    return ihm;
  }

  private Formulaire form;
  private CanvasIHM pendu;
	
  private JeuPenduIHM() {
		
    form =new Formulaire("JEU DU PENDU",JeuPendu.getInstance(),350,600,true);
		
    form.setPosition(10,10);
    form.horizontal();
    form.addText("MOTATROUVER", "Saisir mot", true, "");
    form.addButton("VALIDER_MOTATROUVER", "Valider");
    form.dessous(10);
    form.vertical();
    form.addButton("GENERER_MOTATROUVER", "Gnrer mot  trouver");
    form.setWidthTextCour(300);
    form.addText("MOTAAFFICHER", "", true, "");
    form.setWidthTextCour(100);
    form.horizontal();
    form.setWidthTextCour(50);
    form.addText("LETTREAPROPOSER", "Lettre", true, "");
    form.addButton("VALIDER_LETTREAPROPOSER", "Valider");
    form.dessous(10);
    form.setWidthTextCour(100);
    form.addText("MOTAPROPOSER", "Mot", true, "");
    form.addButton("VALIDER_MOTAPROPOSER", "Valider");
    form.dessous(10);
    form.vertical();
    //form.setWidthTextCour(200);
    form.addText("INFORMATION", "", false, "");
    //form.setWidthTextCour(50);
    form.addText("NB_ERREUR", "Nb erreur", false, "");
		
    pendu = form.addCanvasIHM(300, 300, null);
		
  }

  public Formulaire getForm() {
    return form;
  }
	
  public void notifier() {
    rafraichirInfos();
    afficherPendu();
  }
	
  private void rafraichirInfos() {
    //form.setValeurChamp("MOTATROUVER", JeuPendu.getInstance().getMotATrouver());
    form.setValeurChamp("MOTAAFFICHER", JeuPendu.getInstance().getMotAAficher());
    form.setValeurChamp("INFORMATION",JeuPendu.getInstance().getInformation());
    form.setValeurChamp("NB_ERREUR", ""+JeuPendu.getInstance().getNbErreur());
  }
	
  private void afficherPendu() {
    int nbErreur=JeuPendu.getInstance().getNbErreur();
		
    pendu.effacerCanvas();
		
    // Potence
    pendu.ajouterLigne(1, 10, 10, 200, 10);
    pendu.ajouterLigne(1, 10, 10, 10, 300);
    pendu.ajouterLigne(1, 0, 300, 20, 300);
		
    // centre de la tte
    int x=150;
    int y=50;
    double rayon=20.0;
    // Affichage de la tete
    if (nbErreur>=1) {
      int px1=0;int py1=0;
      int px2;int py2;
      for(int i=0;i<=360;i=i+5) {
        double angle = (double)i;
        px2=(int)(rayon*Math.cos(angle*Math.PI/180.0));
        py2=(int)(rayon*Math.sin(angle*Math.PI/180.0));
        if (i!=0) pendu.ajouterLigne(1, x+px1, y+py1, x+px2, y+py2);
        px1=px2;
        py1=py2;
      }
    }
    y=y+(int)rayon;
    if(nbErreur>=2) pendu.ajouterLigne(1, x, y, x, y+100);    // tronc
    y=y+50;
    if(nbErreur>=3) pendu.ajouterLigne(1, x, y, x+50, y-50);  // bras
    if(nbErreur>=4) pendu.ajouterLigne(1, x, y, x-50, y-50);  // bras
    y=y+50;
    if(nbErreur>=5) pendu.ajouterLigne(1, x, y, x+50, y+50);  // jambe
    if(nbErreur>=6) pendu.ajouterLigne(1, x, y, x-50, y+50);  // jambe
    y=y-100-2*(int)rayon;
    if(nbErreur>=7) pendu.ajouterLigne(1, x, y, x, y-20);     // corde
  }
	
}
