package fr.cnam.jeupendu;

import java.util.*;

import fr.cnam.ihm.CanvasIHM;
import fr.cnam.ihm.Formulaire;

public class JeuPenduIHMActions implements Observer {

  // Le Singleton
  private static JeuPenduIHMActions ihm = null;

  // Accs au singleton
  static public JeuPenduIHMActions getInstance(){
    if (ihm==null) ihm = new JeuPenduIHMActions();
    return ihm;
  }

  private Formulaire form;
	
  private JeuPenduIHMActions() {
		
    form =new Formulaire("JEU DU PENDU",JeuPendu.getInstance(),350,600,true);
		
    form.setPosition(10,10);
    form.horizontal();
    form.addText("MOTATROUVER", "Saisir mot", true, "");
    form.addButton("VALIDER_MOTATROUVER", "Valider");
    form.dessous(10);
    form.vertical();
    form.addButton("GENERER_MOTATROUVER", "Gnrer mot  trouver");
    form.setWidthTextCour(300);
    form.addText("MOTAAFFICHER", "", true, "");
    form.setWidthTextCour(100);
    form.horizontal();
    form.setWidthTextCour(50);
    form.addText("LETTREAPROPOSER", "Lettre", true, "");
    form.addButton("VALIDER_LETTREAPROPOSER", "Valider");
    form.dessous(10);
    form.setWidthTextCour(100);
    form.addText("MOTAPROPOSER", "Mot", true, "");
    form.addButton("VALIDER_MOTAPROPOSER", "Valider");
    form.dessous(10);
    form.vertical();
    //form.setWidthTextCour(200);
    form.addText("INFORMATION", "", false, "");
    //form.setWidthTextCour(50);
    form.addText("NB_ERREUR", "Nb erreur", false, "");

    JeuPendu.getInstance().getObservable().addObserver(this);
		
  }

  public Formulaire getForm() {
    return form;
  }
	
  public void update(Observable obs, Object arg) {
    rafraichirInfos();
  }
	
  private void rafraichirInfos() {
    //form.setValeurChamp("MOTATROUVER", JeuPendu.getInstance().getMotATrouver());
    form.setValeurChamp("MOTAAFFICHER", JeuPendu.getInstance().getMotAAficher());
    form.setValeurChamp("INFORMATION",JeuPendu.getInstance().getInformation());
    form.setValeurChamp("NB_ERREUR", ""+JeuPendu.getInstance().getNbErreur());
  }
	
}
