// Exemple simple en RMI : le message HELLO

import java.lang.*;
import java.io.*;

// Les packages indispensables pour utiliser RMI
import java.rmi.*;
import java.rmi.registry.*;
import java.rmi.server.*;
import java.net.InetAddress;
import java.net.DatagramSocket;

// Le programme serveur qui cre l'OD
public class ExempleCh03_01
{
    public static void main(String args[]) throws Exception
    {
      // La mthode InetAddress.getLocalHost().getHostAddress() ne retourne pas ncessairement la bonne adresse IP 
      // 
      //String ipLocale = InetAddress.getLocalHost().getHostAddress();
      String ipLocale = getLocalIpViaSocket();

      System.out.println("Adresse IP local : "+ipLocale);

      // Indispensable dans certains cas afin de s'assurer que l'adresse IP
      // de la machine locale est utilis dans la cration du stub (et non
      //  l'adresse local 127.0.0.1
      //
      System.setProperty("java.rmi.server.hostname", ipLocale);

        // Cration du service de nommage utilis par RMI
        try{
            LocateRegistry.createRegistry(9100);
        } catch(Exception ex){};

        // Cration de l'objet distribu
        System.out.println("Cration de l'objet distribu");
        HelloOD od = new HelloOD(9101,
                                 "Bonjour, je m'apelle Pierre DUPONT");

        // Enregsitrement de l'OD dans l'annuaire sous le nom "HELLO"
        //  Ce nom doit tre unique dans l'annuaire
        System.out.println("Enregistrement de l'objet distribu");
        Naming.rebind("rmi://localhost:9100/HELLO",od);

        /* Un server de socket est instanci et est excut en fond par
           un thread. Ce qui explique que si on ne fait pas les lignes qui suivent
           le programme ne s'arrte pas.
           
           Pour terminer proprement, il faut tuer proprement tous les OD, ce qui
           provequera la fin du serveur de socket
        */

        System.out.println("Bus en ecoute....");
        // L'oprateur dcide l'arrt de l'OD
        DataInputStream in = new DataInputStream(System.in);
        System.out.print("Taper rc, pour arreter le serveur...");
        System.out.flush();
        String valeur= in.readLine();

        // Dsenregistrement de l'OD de l'annuaire
        Naming.unbind("rmi://localhost:9100/HELLO");

        // Destruction de l'OD
        UnicastRemoteObject.unexportObject(od,true); // true : pour forcer

    }

  public static String getLocalIpViaSocket() {
    try (DatagramSocket socket = new DatagramSocket()) {
        // L'adresse distante n'a pas besoin d'tre joignable (pas d'envoi)
        socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
        return socket.getLocalAddress().getHostAddress();
    } catch (Exception e) {
        return "127.0.0.1";
    }
  }
}
