// Serveur.java
// Le serveur cree l'annuaire, cree le factory et l'enregistre dans l'annuaire
//

import java.io.*;
import java.awt.*;
import java.net.*;

/* Les packages de RMI */
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.net.InetAddress;
import java.net.DatagramSocket;

public class Serveur
{
    public static void main(String args[]) throws RemoteException,ServerNotActiveException,MalformedURLException, IOException
    {
      String ipLocale = getLocalIpViaSocket();
       System.setProperty("java.rmi.server.hostname", ipLocale);

        // Creation de l'annuaire s'il n'existe pas dj
        try{
            LocateRegistry.createRegistry(9100);
        } catch(Exception ex){};

        // Creation du factory de devise
        //
        Naming.rebind("rmi://localhost:9100/DEVISES",
                      new FactoryDevise());
    }

 public static String getLocalIpViaSocket() {
    try (DatagramSocket socket = new DatagramSocket()) {
        // L'adresse distante n'a pas besoin d'tre joignable (pas d'envoi)
        socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
        return socket.getLocalAddress().getHostAddress();
    } catch (Exception e) {
        return "127.0.0.1";
    }
  }
}


