// Exemple du DP Singleton

import java.util.*;
import java.io.*;

// Programme principal du test du factory
//
public class ExempleCh04_02
{
  public static void main(String[] args)
  {
    Log.getInstance().logguer("toto");
    Log.getInstance().logguer("tata");
    
    Bidon bidon= new Bidon();
    bidon.call();
  }
}

class Log
{
  private static Log singleton = new Log();
  private String fichierLog;
  private int numero;
  private PrintStream pos;

  private Log() 
  {
    fichierLog = "../log.txt";
    numero=0;
    try{pos = new PrintStream(new FileOutputStream(new File(fichierLog)));}catch(Exception ex){}
  }

  public static Log getInstance() 
  {
    return singleton;
  }

  public void logguer(String chaine){
    pos.println(numero+":"+chaine);
    pos.flush();
    numero++;
  }
}


class Bidon{
  public void call(){
    Log.getInstance().logguer("call de Bidon");
  }
}
