// Programme qui montre une injection de dependance par un fichier de configuration 
//
import java.util.*;

import fr.cnam.test.*;

public class ExempleCh04_04
{ 
    public static void main(String[] args) throws Exception
    {
        // Liaison directe
        System.out.println("CAS 1 : Avec une liaison directe");

        PersonneLister plist = new PersonneLister("../carnet.txt");
        List<Personne> lp = plist.chercherParNom(null);
        for(Personne p:lp) System.out.println(p.toString());

        System.out.println("====================================================");


        // Utilisation d'un fichier de configuration 
        // 
        System.out.println("CAS 2 : Avec injection de la classe LecteurFichierPersonne");
        Injecteur injecteur = new Injecteur();
        PersonneLister lister = (PersonneLister)injecteur.injecter("../config1.txt","fr.cnam.test.PersonneLister");
        
        lp = lister.chercherParNom(null);
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("Recherche de LAF :");
        System.out.println("------------------");
        lp = lister.chercherParNom("LAF");
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("====================================================");

        // Utilisation d'un deuxieme fichier de configuration
        System.out.println("CAS 3: Avec injection de la classe InitPersonne");
        
        injecteur = new Injecteur();
        lister = (PersonneLister)injecteur.injecter("../config2.txt","fr.cnam.test.PersonneLister");
        
        lp = lister.chercherParNom(null);
        for(Personne p:lp)
            System.out.println(p.toString());

        System.out.println("Recherche de AAA :");
        System.out.println("------------------");
        lp = lister.chercherParNom("AAA");
        for(Personne p:lp)
            System.out.println(p.toString());


        // Pour dmontrer que l'injection fonctionne bien pour n'importes classes
        System.out.println("====================================================");
        injecteur = new Injecteur();
        A a = (A)injecteur.injecter("../config2.txt","fr.cnam.test.A");
        a.proc();

    }
}