package fr.cnam.test;

import fr.cnam.util.*;
import java.lang.reflect.*;

public class Injecteur {


  public Object injecter(String configuration,String nomClassCible) throws Exception
  {
    // Rcupration de l'injection  raliser dans le fichier de configuration
    // ------------------------------------------------------------------

    Injection injection = lireInjection(configuration,nomClassCible);


    // Cration dynamique de l'instance de la classe  injecter
    // ------------------------------------------------------------------

    Class<?> classeAInjecter = Class.forName(injection.classeAInjecter,true, 
                                             ClassLoader.getSystemClassLoader());
    Class<?>[] classes = new Class<?>[injection.params.length];
    int i=0;
    for(String a :injection.params )
      classes[i++]=String.class;
    Constructor constrClasseAInjecter = classeAInjecter.getConstructor(classes);

    Object objetAInjecter = constrClasseAInjecter.newInstance((Object[])injection.params);


    // Cration dynamique de l'instance de la classe cible
    // ------------------------------------------------------------------
    
    Class<?> classeCible = Class.forName(injection.classeCible,true, 
                                         ClassLoader.getSystemClassLoader());
    Constructor constrClasseCible = classeCible.getConstructor();
    Object objetCible = constrClasseCible.newInstance();

    // Construction du setteur
    // ------------------------------------------------------------------

    String nomMethodeSetteur = "set"+injection.nomSetteur.substring(0,1).toUpperCase()+
      injection.nomSetteur.substring(1,injection.nomSetteur.length());


    Class<?> classeInterface = Class.forName(injection.classeInterface,true, 
                                             ClassLoader.getSystemClassLoader());
    Method setteur = classeCible.getMethod(nomMethodeSetteur,classeInterface);

    // Appel du setteur: ralisation de la dpendance entre les deux instances
    // ------------------------------------------------------------------

    setteur.invoke(objetCible,objetAInjecter);
    

    return objetCible;
  }

  public Injection lireInjection(String configuration,String nomClasseCible)
  {
    Injection injection = new Injection();
    injection.classeCible=nomClasseCible;

    String[] lignes = Terminal.lireFichierTexte(configuration);
    String suite="";
    for(String l:lignes){
      int index = l.indexOf(" ");
      String mot = l.substring(0,index);
      if(mot.equals(nomClasseCible)){
        suite=l.substring(index+1,l.length());
        break;
      }
    }
    int index = suite.indexOf(" ");
    injection.nomSetteur=suite.substring(0,index);
    suite=suite.substring(index+1,suite.length());

    index = suite.indexOf(" ");
    injection.classeInterface=suite.substring(0,index);
    suite=suite.substring(index+1,suite.length());
    
    index = suite.indexOf("(");
    injection.classeAInjecter=suite.substring(0,index);
    suite=suite.substring(index+1,suite.length());

    index = suite.indexOf(")");
    if(index==0) injection.params= new String[0];
    else{
      String params = suite.substring(0,index);
      injection.params=params.split(",");
    }

    return injection;
  }

  class Injection{
    String classeCible;
    String nomSetteur;
    String classeInterface;
    String classeAInjecter;
    String [] params;
  }
}