// Exemple du DP Proxy

import java.util.*;

public class ExempleCh04_05
{
  public static void main(String[] args)
  {
    // --------------------------------------------------------
    System.out.println("SANS LE PROXY:");
    Applicatif  appImp = new ApplicatifImp();
    Ihm ihm1 = new Ihm(appImp);
    
    ihm1.exemple();

    // --------------------------------------------------------
    System.out.println("\nAVEC LE PROXY:");

    ApplicatifProxy appProxy;
    try{
      System.out.println("\n=================\n");
      appProxy = new ApplicatifProxy(appImp,"jacques","12345678");
      Ihm ihm2 = new Ihm(appProxy);
      ihm2.exemple();
    }catch(Exception ex){System.out.println("**** Erreur d'identification");}

    try{
      System.out.println("\n=================\n");
      appProxy = new ApplicatifProxy(appImp,"pierre","12345");
      Ihm ihm2 = new Ihm(appProxy);
      ihm2.exemple();
    }catch(Exception ex){System.out.println("**** Erreur d'identification");}

        
    // Exemple d'utilisation du Proxy
    // Separation de l'ihm et de son applicatif
    System.out.println("\n=================\n");

    appProxy = new ApplicatifProxy(appImp,"jacques","12345");

    Ihm ihm2 = new Ihm(appProxy);
    ihm2.exemple();
  }
}

// --------------------------------------------------------
class Ihm 
{
  private Applicatif app;
    
  public Ihm(Applicatif app)
  {
    this.app = app;
  }

  public void exemple()
  {
    System.out.println("------ exemple -----");
    int x = app.getX();
    int y = app.getY();
    app.setX(100);
    app.traitement();
  }
}

// --------------------------------------------------------
interface Applicatif
{
  public int getX();
  public int getY();
  public void setX(int x);
  public void setY(int y);
  public void traitement();
}

// --------------------------------------------------------
class ApplicatifImp implements Applicatif
{
  private int x;
  private int y;

  public ApplicatifImp()
  {
    x=10;
    y=20;
  }

  public int getX(){System.out.println("getX");return x;}
  public int getY(){System.out.println("getY");return y;}
  public void setX(int x){System.out.println("setX");this.x=x;}
  public void setY(int y){System.out.println("setX");this.y=y;}
    
  public void traitement()
  {
    System.out.println("traitement");
  }
}

// --------------------------------------------------------
class ApplicatifProxy implements Applicatif
{
  private Applicatif app;
  private String     user;
  private Annuaire   annuaire;
  private boolean    autorise;

  public ApplicatifProxy(Applicatif app, String user,String password)
  {
    this.app=app;
    this.user = user;
    annuaire = new Annuaire();
    autorise = annuaire.controleIdentification(user,password);
  }

  public int getX()
  {
    System.out.println("Appel a getX par " + user);
    if (! autorise) throw new RuntimeException("Erreur identification");
    return app.getX();
  }
  public int getY()
  {
    System.out.println("Appel a getY par " + user);
    return app.getY();
  }
  public void setX(int x)
  {
    System.out.println("Appel a setX par " + user);
    app.setX(x);
  }
  public void setY(int y)
  {
    System.out.println("Appel a setY par " + user);
    app.setY(y);
  }
    
  public void traitement()
  {
    System.out.println("Appel a traitement par " + user);
    app.traitement();
  }
}

// --------------------------------------------------------
class Annuaire
{
  private Hashtable<String,String> base;

  public Annuaire(){
    base=new Hashtable<String,String>();
    base.put("jacques","12345");
    base.put("denis","abcdef");
    base.put("robert","ABCDEF");
  }
  
  public boolean controleIdentification(String user,String password){
    String s = base.get(user);
    if (s==null) return false;
    return (base.get(user).equals(password));
  }
}

