// Exemple du DP Decorateur
//
import java.util.*;

public class ExempleCh04_06
{
  public static void main(String[] args)
  {
    // Creation et affichage d'une gaufre au chocolat.
    //
    System.out.println(new Chocolat(new Gaufre()));
    System.out.println(new Chantilly(new Chocolat(new Gaufre())));

    // Creation et affichage d'une crepe au chocolat et chantilly.
    //
    System.out.println(new Chantilly(new Chocolat(new Crepe())));
  }
}

// ---------------------------------------------------------
// La classe abstraite Dessert
//
abstract class Dessert
{
  private String libelle;// Libelle du dessert.
  private double prix;// Prix du dessert.
        
  // Accesseurs en lecture pour le libelle et le prix.
  public String getLibelle()
  {
    return libelle;
  }
  public double getPrix()
  {
    return prix;
  }
        
  // Accesseurs en ecriture pour le libelle et le prix.
  protected void setLibelle(String libelle)
  {
    this.libelle = libelle;
  }
  protected void setPrix(double prix)
  {
    this.prix = prix;
  }
        
  // Methode utilisee pour l'affichage d'un dessert.
  public String toString()
  {
    return String.format("%s : %.2f  euros\n",getLibelle(),getPrix());
  }
}

// ---------------------------------------------------------
// Classe gaufre qui herite de dessert
class Gaufre extends Dessert
{
  // Constructeur qui intialise le libelle et le prix.
  public Gaufre()
  {
    setLibelle("Gaufre");
    setPrix(1.80);
  }
}

// ---------------------------------------------------------
// Classe crepe qui herite de dessert.
class Crepe extends Dessert
{
  // Constructeur qui initialise le libelle et le prix.
  public Crepe()
  {
    setLibelle("Crepe");
    setPrix(1.50);
  }
}

// ---------------------------------------------------------
// Classe abstraite decorateurIngredient qui herite de dessert.
abstract class DecorateurIngredient extends Dessert
{
  protected Dessert dessert;// Dessert sur leuquel on applique l'ingredient.
        
  // On oblige les ingredients  implementer la methode getLibelle().
  public abstract String getLibelle();
  // On oblige les ingredients  implementer la methode getPrix().
  public abstract double getPrix();
}

// ---------------------------------------------------------
//Classe chantily qui herite de decorateurIngredient et donc indirectement de dessert.
class Chantilly extends DecorateurIngredient
{
  // Constructeur qui prend en parametre le dessert.
  public Chantilly(Dessert d)
  {
    dessert = d;
  }
        
  // On affiche le libelle du dessert et on rajoute le libelle de l'ingredient chantilly.
  public String getLibelle()
  {
    return dessert.getLibelle()+", chantilly";
  }
        
  // On additionne le prix du dessert et le prix de l'ingredient chantilly.
  public double getPrix()
  {
    return dessert.getPrix()+0.50;
  }
}
// Classe chocolat qui herite de decorateurIngredient et donc indirectement de dessert.
class Chocolat extends DecorateurIngredient
{
  // Constructeur qui prend en parametre le dessert.
  public Chocolat(Dessert d)
  {
    dessert = d;
  }
        
  // On affiche le libelle du dessert et on rajoute le libelle de l'ingredient chocolat.
  public String getLibelle()
  {
    return dessert.getLibelle()+", chocolat";
  }
        
  // On additionne le prix du dessert et le prix de l'ingredient chocolat.
  public double getPrix()
  {
    return dessert.getPrix()+0.20;
  }
}




