// Exemple du DP Composite
//
import java.util.*;

public class ExempleCh04_07
{
  public static void main(String[] args)
  {
    //                  *
    //            +          -
    //        10     20      /
    //                    30   6
    //
    //    = -150
    //
    Expression exp = new OperateurB("*")
      .add(new OperateurB("+")
           .add(new Operande(10))
           .add(new Operande(20)))
      .add(new OperateurU("-")
           .add(new OperateurB("/")
                .add(new Operande(30))
                .add(new Operande(6))));

    System.out.println("\nRESULTAT : "+exp.evaluer());
    exp.print();

  }
}
//---------------------------------------
abstract class Expression
{
  abstract double evaluer();
  abstract void print();
}

class Operande extends Expression
{
  private double val;
  public Operande(double d){val=d;}
  public double evaluer(){return val;}
  public void print(){
    System.out.print(val+" ");
  }
}

abstract class Operateur extends Expression
{
  protected String operateur;
  protected ArrayList<Expression> elements;
  public Operateur(String operateur){
    this.operateur=operateur;
    elements = new ArrayList<Expression>();
  }
  public Operateur add(Expression e){
    elements.add(e);
    return this;
  }
}

class OperateurB extends Operateur
{
  public OperateurB(String operateur){
    super(operateur); }
  public double evaluer() {
    if (operateur.equals("*"))
      return elements.get(0).evaluer()*elements.get(1).evaluer();
    if (operateur.equals("+"))
      return elements.get(0).evaluer()+elements.get(1).evaluer();
    if (operateur.equals("/"))
      return elements.get(0).evaluer()/elements.get(1).evaluer();
    throw new RuntimeException("Operateur inconnue");
  }
  public void print(){
    elements.get(0).print();
    elements.get(1).print();
    System.out.print(operateur+" ");
  }
}

class OperateurU extends Operateur
{
  public OperateurU(String operateur){
    super(operateur); }
  public double evaluer() {
    if (operateur.equals("-"))
      return -elements.get(0).evaluer();
    throw new RuntimeException("Operateur inconnue");
  }
  public void print(){
    elements.get(0).print();
    System.out.print(operateur+" ");
  }
}

