// Exemple du DP Iterateur

public class ExempleCh04_08
{
    public static void main(String[] args)
    {
        // Création de ma collection
        MyCollection c = new MyCollection(100);
        c.add("UN");
        c.add("DEUX");
        c.add("TROIS");
        c.add("QUATRE");
        
        // Itération sur la collection
        Iterator2 it = c.getIterator();
        while (it.hasNext()) {System.out.println( (String)(it.next()) ); }

        System.out.println("--------");
        c.add("CINQ");

        // Deuxième itération sur la collection
        it = c.getIterator();
        while (it.hasNext()) {System.out.println( (String)(it.next()) ); }

    }
}

// Interface de création de l'itérateur
interface Iterable2
{
    // Retourne un iterateur
    public Iterator getIterator();
}

// Interface de l'itérateur
interface Iterator2
{
    // Retourne vrai si il existe encore un élément
    public boolean hasNext();

    // Retourne l'élément courant et passe à l'élément suivant
    public Object next();
}

// ======================================

// Exemple de l'implémentation d'une collection qui 
//   implémente un itérateur
//
// Le choix de l'implémentation de la colleciton est
//  un tableau contenant les éléments et un entier
//  qui défini le nomnre d'élément ajouté dans le tableau.
// Les éléments sont ajoutés de gauche à droite à partir de 0.
//
class MyCollection implements Iterable2
{
    private int max;        // Taille physique du tableau

    private Object[] tab;   // Tableau contenant les éléments
    private int      nb;    // Nombre des éléments

    // Constructeur
    //
    public MyCollection(int max)
    {
        this.max = max;
        this.tab = new Object[this.max];
        this.nb = 0;
    }

    // Ajout d'un élément dans la collection
    //
    public void add(Object o)
    {
        if (nb!=max)
            {
                tab[nb]=o;
                nb++;
            }
    }

    // Retourne le nombre d'élément de la collection
    //
    public int getNb()
    {
        return nb;
    }

    // Retourne l'élément à un indice
    //
    public Object getElement(int indice)
    {
        return tab[indice];
    }

    // ---- Implémentation de la méthodes de l'interface BuildIterateur
    //
    // Cette méthode retourne un objet qui implémente l'interface
    //   Iterateur et qui prend en entrée la collection
    //
    public Iterator2 getIterator()
    {
        // L'iterateur est créé à chaque appel
        return new MyIterateur(this);
    }

}

// Classe de définition de notre itérateur
//   Implémente l'interface Iterateur
//
class MyIterateur implements Iterator2
{
    private MyCollection collection;  // La collection
    private int indice;               // L'indice courant

    // Constructeur
    //
    public MyIterator2(MyCollection collection)
    {
        this.collection = collection;
        this.indice = 0;  // L'indice est à 0 au départ
        
    }

    // Retourne vrai si il existe encore un élément
    //
    public boolean hasNext()
    {
        return (indice < collection.getNb() );
    }

    // Retourne l'élément courant et passe à l'élément suivant
    //
    public Object next()
    {
        Object o = (Object)(collection.getElement(indice));
        indice++;
        return o;
    }
}
    