// Exemple du DP Strategie
//
import java.util.*;

public class ExempleCh04_09
{
  public static void main(String[] args)
  {
    Panier p = new Panier();
    p.ajouterArticle(new Article("Ordi",875.0));
    p.ajouterArticle(new Article("Cable HDMI",25.0));
    p.ajouterArticle(new Article("Housse",100.0));
    p.setConnexion(new ConnexionBanque("LCL","6754H"));
    p.payerEnLigne();
    System.out.println("=================================");
    p.setConnexion(new ConnexionPaypal("john.doe@mail.com","****"));
    p.payerEnLigne();
  }
}
//---------------------------------------
interface IConnexionPaiement
{
  public void contacter();
  public boolean confirmer();
  public void payer(double montant);
}

//---------------------------------------
class ConnexionBanque implements IConnexionPaiement
{
  private String banque;
  private String compte;

  public ConnexionBanque(String banque,String compte)
  {
    this.banque=banque;
    this.compte=compte;
  }
  
  public void contacter()
  {
    System.out.println("Contacte de la banque : "+banque+" "+compte);
  }
  public boolean confirmer()
  {
    System.out.println("Confirmation de la banque?");
    return(true);
  }
  public void payer(double montant)
  {
    System.out.println("Le compte "+compte+"est debite de "+montant);
  }
}

//---------------------------------------
class ConnexionPaypal implements IConnexionPaiement
{
  private String mail;
  private String mdp;

  public ConnexionPaypal(String mail,String mdp)
  {
    this.mail=mail;
    this.mdp=mdp;
  }
  
  public void contacter()
  {
    System.out.println("Contacte a PAYPAL : "+mail+" "+mdp);
  }
  public boolean confirmer()
  {
    System.out.println("Confirmation de paypal?");
    return(false);
  }
  public void payer(double montant)
  {
    System.out.println("PAYPAL est debite de "+montant+"pour "+mail);
  }
}

//---------------------------------------
class Panier
{
  private IConnexionPaiement connexion;
  private double somme;
  private ArrayList<Article> articles;

  public Panier()
  {
    articles=new ArrayList<Article>();
    somme=0.0;
  }

  public void ajouterArticle(Article a)
  {
    articles.add(a);
    somme=somme+a.getPrix();
  }

  public void payerEnLigne()
  {
    if (connexion==null) System.out.println("Pas de connexion");
    else  {
      connexion.contacter();
      if (connexion.confirmer())
        connexion.payer(somme);
      else
        System.out.println("Impossible de  payer");
    }
  }

  public void setConnexion(IConnexionPaiement connexion)
  {
    this.connexion=connexion;
  }
}

//---------------------------------------
class Article
{
  private String article;
  private double prix;
  public Article(String article,double prix)
  {
    this.article=article;
    this.prix=prix;
  }
  public double getPrix()
  {
    return prix;
  }
}