// Exemple du DP Observer
// Cas : Synchrone avec separation du changement d'etat et de la notification
//
import java.util.*;

public class ExempleCh04_10b
{
    public static void main(String[] args)
    {
        App a = new App();

        Utilisateur u1 = new Utilisateur("U1",a.getObservable());
        Utilisateur u2 = new Utilisateur("U2",a.getObservable());
        
        traitement(a);
        
    }

    static public void traitement(App app)
    {
        for(int i=0;i<10;i++)
            {
                if (i!=5)
                    {
                        app.setEtat1(i);
                        app.setEtat2(i*100);
                    }
                app.setValide(true);
                try{Thread.sleep(1000);}catch(Exception ex){};
            }
    }

}

// ------------------------------------
class App
{
    private int etat1;
    private int etat2;
    private boolean valide;

    private ObservableApp obs;

    public App()
    {
        etat1 = 1;
        etat2 = 100;
        valide = false;
        obs = new ObservableApp();
    }

    public void setEtat1(int v)
    {
        etat1 = v;
        obs.setChanged();
    }

    public void setEtat2(int v)
    {
        etat2 = v;
        obs.setChanged();
    }

    public void setValide(boolean v)
    {
        valide = v;
        if (valide)
            {
                String arg = etat1+" "+etat2;
                obs.notifyObservers(arg); // teste si changed
            }
    }
   

    public Observable getObservable(){return obs;}

}

// ------------------------------------
class ObservableApp extends Observable 
{
    public void setChanged() // car setChanged est protected
    {
        super.setChanged();
    }
}

// ------------------------------------
class ObserverApp implements Observer
{
    Utilisateur util;

    public ObserverApp(Utilisateur util)
    {
        this.util = util;
    }

    public void update(Observable o,Object arg)
    {
        String v = (String)arg;
        util.traitement(v); // APPEL AU TRAITEMENT
    }
}

// ------------------------------------
class Utilisateur
{
    private ObserverApp observer;
    private String      ident;

    public Utilisateur(String ident,Observable observable)
    {
        this.ident = ident;
        observer = new ObserverApp(this);  // this
        
        observable.addObserver(observer);
    }

    // traitement de utilisateur appelé
    public void traitement(String v)
    {
        System.out.println(ident+" "+v);
    }
}
