// Exemple du DP Observer
// Cas : Avec un proxy
//
import java.util.*;

public class ExempleCh04_10c
{
    public static void main(String[] args)
    {
        App a = new App();
        ProxyApp proxy = new ProxyApp(a);

        Utilisateur u1 = new Utilisateur("U1",proxy.getObservable());
        Utilisateur u2 = new Utilisateur("U2",proxy.getObservable());

        
        traitement(proxy);
        
    }

    static public void traitement(AppInt app)
    {
        for(int i=0;i<10;i++)
            {
                if (i!=5)
                    {
                        app.setEtat1(i);
                        System.out.println(String.format("%30s","setEtat1 de "+i));
                        app.setEtat2(i*100);
                        System.out.println(String.format("%30s","setEtat2 de "+(i*100)));
                    }
                app.setValide(true);
                try{Thread.sleep(1000);}catch(Exception ex){};
            }
    }

}
// ------------------------------------
interface AppInt
{
    public void setEtat1(int v);
    public void setEtat2(int v);
    public void setValide(boolean v);
}
// ------------------------------------
class ProxyApp implements AppInt
{
    private ObservableApp obs;
    private App app;

    public ProxyApp(App a)
    {
        app=a;
        obs = new ObservableApp();
    }
    
    public void setEtat1(int v)
    {
        app.setEtat1(v);
        obs.setChanged();
    }

    public void setEtat2(int v)
    {
        app.setEtat2(v);
        obs.setChanged();
    }

    public void setValide(boolean v)
    {
        app.setValide(v);
        if (app.getValide())
            {
                String arg = app.getEtat1()+" "+app.getEtat2();
                obs.notifyObservers(arg); // teste si changed
            }
    }

    public Observable getObservable(){return obs;}

}

// ------------------------------------

class App implements AppInt
{
    private int etat1;
    private int etat2;
    private boolean valide;

    public App()
    {
        etat1 = 1;
        etat2 = 100;
        valide = false;
    }

    public void setEtat1(int v)
    {
        etat1 = v;
    }

    public void setEtat2(int v)
    {
        etat2 = v;
    }

    public void setValide(boolean v)
    {
        valide = v;
    }

    public boolean getValide() {return valide;}
    public int getEtat1(){return etat1;}
    public int getEtat2(){return etat2;}

}

// ------------------------------------
class ObservableApp extends Observable 
{
    public void setChanged() // car setChanged est protected
    {
        super.setChanged();
    }
}

// ------------------------------------
class ObserverApp implements Observer
{
    Utilisateur util;

    public ObserverApp(Utilisateur util)
    {
        this.util = util;
    }

    public void update(Observable o,Object arg)
    {
        String s = (String)arg;
        util.traitement(s); // APPEL AU TRAITEMENT
    }
}

// ------------------------------------
class Utilisateur
{
    private ObserverApp observer;
    private String      ident;

    public Utilisateur(String ident,Observable observable)
    {
        this.ident = ident;
        observer = new ObserverApp(this);  // this
        
        observable.addObserver(observer);
    }

    // traitement de utilisateur appelé
    public void traitement(String v)
    {
        System.out.println(ident+" "+v);
        // Pour simuler un cas de traitement long par l'utilisateur
        if ( v.contains("700") && ident.equals("U1") ) attente(10,250,"x");
    }

    public static void attente(int nb,int ms,String trace)
    {
        for(int i=0;i<nb;i++)
            {
                try{Thread.sleep(ms);}catch(Exception ex){};
                System.out.print(trace+" ");
            }
        System.out.println();
    }

}

