// Exemple d'implementation du probleme de l'horloge suivant un modele MVC dans lequel la vue est notifie des changement d'etat de l'horloge par un observable et oberver. 
// L'observer est cree en dehors de la vue et l'observable est cree en dehors du modele afin de faciliter l'implementation du modele en RMI (Voir ExempleCh06_01_ModeleMVC_RMI)

import fr.cnam.horloge.controleur.*;
import fr.cnam.horloge.model.*;
import fr.cnam.horloge.vue.*;

public class ExempleCh04_11
{
    public static void main(String... args)
    {
        // Cration des vues
        VueSaisirHeureHorloge   vue1 = new VueSaisirHeureHorloge();
        VueAfficherHeureHorloge vue2 = new VueAfficherHeureHorloge();
        VueAfficherHeureHorloge vue4 = new VueAfficherHeureHorloge();
        VueSaisirNomHorloge     vue3 = new VueSaisirNomHorloge();

        // Creation de l'observeur afin que vue2 soit notifie
        ObserverHorloge observer = new ObserverHorloge(vue2);
        ObserverHorloge observer2 = new ObserverHorloge(vue4);

        // Affichage des vues
        vue1.afficher();
        vue2.afficher();
        vue3.afficher();
        vue4.afficher();

    }
}