package fr.cnam.horloge.controleur;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import fr.cnam.horloge.model.*;
import fr.cnam.horloge.controleur.*;

// Classe d'implmentation du controleur de l'horloge
// Elle implmente l'interface ControleurHorloge.
//
public class ControleurHorlogeImpl implements ControleurHorloge
{
    private ModelHorloge modelHorloge; // Modele de donne de l'horloge
    
    static private String  host;
    static private int     port;

    // Constructeur
    // Le controleur doit connaitre le modele de donne utilis
    //
    public ControleurHorlogeImpl(ModelHorloge model)
    {
        this.modelHorloge = model;
    }

    // ---------- Les mthodes de l'interface ControleurHorloge
    // ============================================================
    public void actionRenommerHorloge(String nomHorloge)
    {
        if (! nomHorloge.equals(""))
            modelHorloge.renommer(nomHorloge);
    }
    
    public void actionChangerHeureHorloge(HeureHorloge heure)
    {
        if (heure!=null)
            modelHorloge.majHeure(heure);
    }

    public void actionStartHorloge()
    {
        modelHorloge.setArret(false);
    }

    public void actionStopHorloge()
    {
        modelHorloge.setArret(true);
    }


    public void actionNotifier()
    {
        modelHorloge.notifier();
    }


    // Mthode permettant de grer le controleur de l'horloge comme un
    //  singleton.
    // Cela reste la faon la plus simple de faire connaitre le controleur
    //  au programme principal
    //
    // Pour simplifier nous faisons le choix que le modele de donne est
    //   cr par le controleur
    //
    static public ControleurHorloge getInstance()
    {
        if (modelHorlogeSingleton==null)
            {
                modelHorlogeSingleton  = new ModelHorlogeImpl("TOULOUSE", new ObservableHorloge() );
                controleurHorlogeSingleton = new ControleurHorlogeImpl(modelHorlogeSingleton);
            }
        return controleurHorlogeSingleton;
    }

    // Les attributs de singleton
    private static ModelHorloge modelHorlogeSingleton = null;
    private static ControleurHorloge controleurHorlogeSingleton = null;

    // retourne le modele qui est gr par le controleur
    public ModelHorloge getModelHorloge()
    {
        return modelHorloge;
    }
}
